(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    227545,       4853]
NotebookOptionsPosition[    220194,       4717]
NotebookOutlinePosition[    220591,       4733]
CellTagsIndexPosition[    220548,       4730]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Hjelmslev Quadrilaterals - Poncelet point", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, {
  3.947144439694456*^9, 3.947144443366682*^9}, {3.947339713636549*^9, 
  3.947339717251663*^9}, {3.954728574674156*^9, 3.954728576840864*^9}, {
  3.9547567434027576`*^9, 3.9547567507460346`*^9}, {3.955503984824476*^9, 
  3.955503986915159*^9}, {3.9599268529449825`*^9, 
  3.9599268647668095`*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about Hjelmslev \
quadrilaterals in the paper \[OpenCurlyDoubleQuote]More Shapes of Central \
Quadrilaterals\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in July \
2025.

This Notebook is Copyright \[Copyright] July 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947148657900776*^9, 3.947148664004244*^9}, {
  3.947339725299139*^9, 3.947339727179648*^9}, {3.954756786770439*^9, 
  3.954756791707377*^9}, {3.959926872904291*^9, 3.9599268759678173`*^9}, {
  3.9614135196467447`*^9, 
  3.961413527854651*^9}},ExpressionUUID->"22c83543-03f0-524a-b077-\
52bf40ea5d06"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
   3.850469071318833*^9, 3.850469073637095*^9}, 
   3.850469177050805*^9},ExpressionUUID->"4726c28a-23e3-c144-b5b8-\
1febfd23a730"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"b", ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}], ",", 
     RowBox[{"t", ">", "0"}], ",", 
     RowBox[{"t", "<", "1"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.815380012932528*^9, 3.815380017875984*^9}, 
   3.850469040353149*^9, {3.8504693680519905`*^9, 3.850469423540739*^9}, {
   3.850472927885082*^9, 3.8504729485372677`*^9}, {3.850473440747275*^9, 
   3.8504734481722603`*^9}, {3.850475925894286*^9, 3.850475928077327*^9}, {
   3.8504761619065633`*^9, 3.850476174390406*^9}, {3.850556206333856*^9, 
   3.850556223600524*^9}, {3.8505562541705465`*^9, 3.850556312095413*^9}, {
   3.8505595402294674`*^9, 3.850559540656997*^9}, {3.850559577535342*^9, 
   3.8505595778428125`*^9}, {3.957575933740265*^9, 3.957575946500149*^9}, {
   3.957575978072499*^9, 3.957576015387537*^9}, {3.9575760749636536`*^9, 
   3.9575760753069916`*^9}, {3.957577346528906*^9, 3.957577349252188*^9}},
 CellLabel->
  "In[560]:=",ExpressionUUID->"fe7e3f24-57f0-1445-8125-872b46d33312"],

Cell[TextData[StyleBox["Point T on AC such that AT : TC = t : 1, with 0 \
\[LessEqual] t \[LessEqual] 1.",
 FontColor->GrayLevel[0]]], "Text",
 CellChangeTimes->{{3.817293631733445*^9, 3.817293669912202*^9}, {
  3.8172945191307793`*^9, 
  3.817294567706676*^9}},ExpressionUUID->"54ce8b45-a9ff-364a-b007-\
50e763233c41"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptT", "=", 
  RowBox[{"DividirRazon", "[", 
   RowBox[{"ptA", ",", "ptC", ",", "t", ",", "1"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8153943277906637`*^9, 3.8153943533872595`*^9}, {
   3.817293588623359*^9, 3.817293590671271*^9}, 3.8505560088454385`*^9, 
   3.850556165035162*^9},
 CellLabel->
  "In[562]:=",ExpressionUUID->"2b97bda7-fc4c-854c-a342-fa797e627188"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "t"}], "}"}]], "Output",
 CellChangeTimes->{3.815394355261637*^9, 3.815394436413099*^9, 
  3.81727674378023*^9, 3.8172935920367208`*^9, 3.85046938567021*^9, 
  3.85046942698629*^9, 3.850472723754394*^9, 3.850517747901428*^9, 
  3.850554109409218*^9, 3.8505560460500946`*^9, 3.850556124094026*^9, 
  3.850556171368501*^9, 3.850556593131568*^9, 3.850564126489251*^9, 
  3.850564248903241*^9, 3.850567545919678*^9, 3.8505730856858573`*^9, 
  3.8505737165676312`*^9, 3.850913176467263*^9, 3.85091858704643*^9, 
  3.851255515638445*^9, 3.9575759515990715`*^9, 3.957576086890831*^9, 
  3.9575773549090595`*^9, 3.957580057932876*^9, 3.9575801501402645`*^9, 
  3.9599269019006863`*^9, 3.961151491502882*^9, 3.961152298712919*^9, 
  3.96141354816541*^9},
 CellLabel->
  "Out[562]=",ExpressionUUID->"ab8f45db-0ad0-42e9-8443-21607396166a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "assume", " ", "that", " ", "D", " ", "lies", " ", "on", " ", "the", " ", 
    "arc", " ", "of", " ", "circumcircle", " ", "af", " ", "ABC", " ", "taht",
     " ", "not", " ", "contains", " ", "B"}], "*)"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{"ptD", "=", 
   RowBox[{"SegundaInterseccionCircunferencia", "[", 
    RowBox[{"ptT", ",", 
     RowBox[{"{", 
      RowBox[{"ptB", ",", "ptC", ",", "ptA"}], "}"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.957576116748625*^9, 3.957576156811014*^9}, {
  3.961152386315586*^9, 3.961152424110609*^9}},
 CellLabel->
  "In[563]:=",ExpressionUUID->"d4990506-4c5e-3c4f-ae15-03b45e912fc7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["c", "2"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "t"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["b", "2"]}], " ", "t"}], ",", 
   RowBox[{"t", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "t"}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.957576147247395*^9, 3.957576157447836*^9}, 
   3.9575763242565155`*^9, 3.9575773580403376`*^9, 3.957580057950884*^9, 
   3.957580150153263*^9, 3.959926905324779*^9, 3.9611514915208836`*^9, 
   3.961152298722889*^9, 3.961413548208136*^9},
 CellLabel->
  "Out[563]=",ExpressionUUID->"397c396c-daec-4b98-8fcb-1e4698f0d308"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Hjelmslev", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["a", "2"], "+", 
     SuperscriptBox["c", "2"]}], "==", 
    SuperscriptBox["b", "2"]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.959926911121067*^9, 3.9599269322965736`*^9}},
 CellLabel->
  "In[564]:=",ExpressionUUID->"9417ba84-3d4a-9f4f-8034-96c53bd2f1bf"]
}, Closed]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"fc2fcd82-4d50-ec47-b5a7-\
8944aef04ea5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "central", " ", "quadrilateral", " ", "of", " ", "ABCD", " ", "wrt", " ", 
     "a", " ", "point", " ", "E"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ptA", ",", "ptB", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptB", ",", "ptC", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptC", ",", "ptD", ",", "ptE"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"ptD", ",", "ptA", ",", "ptE"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"n_Integer", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{
           RowBox[{"ETC", "[", 
            RowBox[{"[", 
             RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", "#"}], "]"}], "]"}], 
        "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"centralQuadrilateral", "[", 
      RowBox[{"ptX_", ",", "ptE_"}], "]"}], ":=", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Simplificar", "[", 
         RowBox[{"CentroETCTriangulo", "[", 
          RowBox[{"ptX", ",", "#"}], "]"}], "]"}], "&"}], ",", 
       RowBox[{"radialTrianglesOfQuadrilateral", "[", "ptE", "]"}]}], "]"}]}],
     ";"}]}]}]], "Input",
 CellChangeTimes->{{3.954755422028537*^9, 3.954755444302299*^9}, {
   3.954755510189615*^9, 3.9547556654655304`*^9}, {3.954756246303211*^9, 
   3.954756258310093*^9}, {3.954756539544531*^9, 3.954756557385113*^9}, {
   3.954756592197891*^9, 3.954756630631082*^9}, {3.954756965437847*^9, 
   3.954756984534746*^9}, {3.9547570451409245`*^9, 3.9547570732294483`*^9}, {
   3.9547571716004887`*^9, 3.9547571856117535`*^9}, {3.9547572771795826`*^9, 
   3.954757312322375*^9}, {3.95475745528866*^9, 3.954757469730625*^9}, {
   3.954757619426098*^9, 3.9547576217454853`*^9}, 3.954757823439115*^9, {
   3.954758024281746*^9, 3.954758036096319*^9}, 3.9547580746525097`*^9, {
   3.9547582109077053`*^9, 3.954758249530725*^9}, {3.957580088291739*^9, 
   3.957580130173944*^9}, {3.961152314536934*^9, 3.961152345102047*^9}, 
   3.9614135381115437`*^9},
 CellLabel->
  "In[565]:=",ExpressionUUID->"c44d3c99-d821-aa44-a5bf-67b591807924"]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties ", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 
  3.946441726397751*^9}},ExpressionUUID->"2609bf4c-7f5c-314e-a744-\
f86d4be283dd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzt3QlcVFXDP/AZ/5b6eeaxP/XXN0vTHsKMV8ugRciewH0JURMXQtw3SA1N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    "], {{0, 138.56603773584905`}, {669.0566037735848, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{669.0566037735848, 138.56603773584905`},
  PlotRange->{{0, 669.0566037735848}, {0, 138.56603773584905`}}]], "Text",
 CellChangeTimes->{
  3.9599279614205894`*^9},ExpressionUUID->"f2a821f3-330a-5649-abcf-\
5dc2575a85c9"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQlcTfn/P35vf0YeE/6NLzNmGoMm0mT4CDMtxq3QYhJD1kQiFI00aAyT
bNn3rGHImiXLkMgyluyTSEJGpqJwje7opnun0++c8z7ndu65Z71bF+/n4/P4
PD4f3Xvu+7zfr/39WlqO/PGHcCuJRBJjjf7XD6FTPSdNCv253/+P/p+gqJhx
Y6JGj/KL+mn0mNGTvh35/6H/2EAqkXxVRyLB/nc1BAQEBAQEBAQEBAQEBAQE
BAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQE
BAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQE
BAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQE
BERtA1EW5ufk5OS/KENqdyFq5fM8dCG5L5S1vJB3EHBvISwPSNkLTPQUFCqr
amkFkC94gajLHqJblFOseGPMx76bO298Zaq6eXLCmhT5f0Z6HIQu/n18dGyQ
nlidXKrGH/Iq7zdPJxw9erRyrdfYKeXvWn4tiLcByIuk2d2cfujZxF5CQNrR
v62Li1PfDYfKa1U0lu9c2KWORDhsRsYWVIr5AUSVOy3Uo41vO/xXnOcl19r7
yvN+8w7oZedig71G/V/+eGrG36YTgI2LXa8AIEk8PNp0a/SlXUB478Sjx0uN
qn7NB629/XBWpry2FwSBGXWF6+e6d/eJjh7tMz7yj6IK8y/hdcpyL6rcs6nn
2sfJKSDweDEuBV4/3u/voREOGr7ot+V4pTGkhOrU9uB2A2QNMaqUyHqf/8cI
zxQHyBe8qJSfGvp9j1bdWkrRPbIac+SecfTDO7nzJlKmZY93uzpIgiLucksI
7NdDnJxIhtLSYgC9vrJr3muU7/xdyX8phK0MUcsvnN09efFY12+JZ3zbceTC
+IuFr4jvK4qPDR2Q/kzsYmq06pIDewtfW4D7+exaQhNCBrqP9JmxInblyri4
uNWrJ88f9CFpXTk7xW+Nw7F5cdjMCR08caZAZVfQ5X/xh7wuPr/wt3UhUe51
8X+3hw6IiYHS55mTa0MnDXHCmM5eZu89UBabOP+Chj6FoupWmIfkO9cl2+N4
cOSMwmSBsqqMTd6o6Pj8k4TLTy2AJSh4kbOyJUbRrotTGGQaolbk5J6M+hEl
e9sfE0rUevxA1d2InsbUL3qj7N461BpydjlYVAsLIQigxRfr7yi1/qD8586c
6V3rSjtNiM7+x7JIQwRqdW9NB/Wzh8/evggqIt88s2lTzxOlVSXr5/jWr03f
H8k+PBpVsra28ReZ5B5SeWOYGyp8bMfEPmIxgdTPC1+p9Px1wHT6Ci5j4B3l
C2NCXXbCu5mkWbMNd/U8JGYmfTd33rjKFClZHN0aNXRdZOnPhX0hc1dQPSYt
hqJCcX/5HJ8PJDZ+vul/c/oziKokNSX+ayfrXrLF+5Nvl5C3OYi67OqFdX5u
caduq/5TXA/93iqUK+ZJLMbWdv7Vl/Q/vXqWtW5L1KfSlv16H7j3rJYpIP9U
TEOJ5H/OKy7dV1GXonFMqI4GALpFO9YObSCRePQ+/4rpK9ABMSkUxRlDAmx/
CEw+d/pByTM1ggqZkrt7Ds5z6ST9tMm4nccVwm8MgXwTAIdpiaa7iCzbOAPj
9F7Bf/7L/2ExQBQZe8KXJhXqGz8nLATuSFGlPL1nyzqxia/0cNDA/rdo8ds9
sxgBKkXOovBZqATTFTp//fFzY4lNcPSD2rhreL1t9ldsBFBVfnmgq0Qi7b50
T9nbeRUOqEj0HRn1CcW5OydMOFlYC7F6NqjO7gpuIHGITijS1wCmwFA+FYHn
OStbSRugVrdKeT2ku/TTpr+cul9bKrgydYWrFfsdxJuSVFdblPIH7brOtEKk
bPdy//oSx5lJZXqFhkoSxtqyPtwcMJwv3n08u7nYTv9bKjYmNc7Oc2iTWgHg
F/vW2x8aI1RacHXeF/glgmA3jWBnNjMGUeVGBqJPtBkScfc18xOQp/kHAv3r
fdF86t60F4xytezxzp6dpk8e/aVU2mfrRY73JFQqB+VgLyiV8jpEpsaNfUPr
SQM3naZTEYcDUk1sprSltqMBHRAzAFE9ihtt7eJ5olSHKV7mb25nK/n8kyXX
6T4vK/59uNmR3/vgd9sNARno01uTsuL14+SvbQyJ8xBczPeEkoTgz9af0Wft
hukXsQBREcaYJxCetRMN5iOAV4lTmtVWrogxAKjIbeUhffNnkILYwTaWcE1G
QeWxDV6N7aIPZhrB/zCYT4UDp3PS6q4oe/i8Fmuvqh5E90ENEtY7CDwmILH9
aFkWo72CyDfP+l/D5nEn9bIAq8ov9HFmf7g5YDBfvPsAnoLet1RsTGqUnefQ
JrWDwsy4JkYKY1YpsyM6xcyd5VlHIvj6iWBnDjOG8FBYHqjKypjRqqXUx3NX
rq5tR/lY+sbvP+AQC8Ri8MsgntORr57aWmqsIJKeqMpI6mrjnFKg88bcDghK
fue2+n7osP0RwvAV6ICYDsBkHRNXzERXwFT734pDQkPFxZdmNuZzP/7nvOnO
K/5H6Q1gfpjAvjI0zkMaxrxPeJU4okuqPouvOrst4APzyXD2mCcQnrVk4vIR
AOGAGJCHUJsAVGRIurVxI3uWBzNGwnG9bCGp78QFh6TnJubYBWGuePiceWGC
Xzdv6IMBhvPFewDcUzD2LZWRdr7Wb9BoMGIMTXU2uUvM0qc5eBaTwI0i2JlL
hxKZxkwPVGWdnPqZjSBbS/Fwc1sbHrFAXp5y35IQQqBWNYs6ZUE9Vwb/gtcB
wT9Qb8G1NwxfgQ6I6YDdWKFutvP2fIYrCXXKInuJ5PO4JKHVRTf2D/qw6bxz
95kaoSCKvct7fmjyFAUizckE5iWe2cV0uycQhGHMHyl6tcZ/7Hl9hLlZZbha
ccbfkTlDtXZNXJAFyhrSIYI5b2vGMthbQxYPsuPYL+7fdhjKp8Jh+FkYEeCC
g9W8AddepopOGBhaNwIs6iwsE8BTMPotlVF2nkOb1BJwZWqMGJqyeL+f+66H
KkIxSepMPvWE/1s895WaFTIY/Ehh1iJ7G4lN/QlHbvHLQCxtu7FVFCfnClgM
BgFOk6nxKnFynXCmcDqvA6J8vL3dB7MvKRi+Ah0QkwE5ty0Ar/S36eG2MfO2
tuOAFMWNsGEPqekCcz97hd0qZ/rTtcMRH1mH7L5o6ts5/mRF/WCw9CYLQHQa
Q1WV31i/mXJrWXU3utvWfPGmu5mzIEC4g/GG2oiX1+IhLBP+rc0VB+6DAYsH
+/POZqqYyMpiBAcLmB0E2bPZgUR1Hl8MU18Ap682w9cG88W7DxABM7pmNMrO
WxIrYQAOkRFiaIh889TOG/BgCHhHYQYVjxZDoXyS6u6AZRpPT3xBzVCpfHm+
vydqtjn8GMfWa0ILmNlg47eNSywIvTwlS4BrUbkozqQyNzjidUDU/+asi0vN
fcbwFeCAqJWFKXtmeQ35xlqCtVft803MxjX3WVJu1Y/vn4pfMtZ1EOgeZuPC
2SgMffKRtPXB4/vbgyZ10o7+TkOmRew8d1FOM5dzT07t4OTk5OLSti+6DPtF
KWpEVZKSPLWj7Aureq4hPivO59BcTkErkd/e4AHamuHtzsD+cL0vosy+nBwS
3bepPf7M5iNmTvz9gV79BwivHEDaLXrcUc1zQNmUS6fUv4XyoDwpvl1Ckm51
OVJ0e0XbOp5mKPvVdHoxeixOyE0lJ1gLQArPD+uttVrkddlrPcQekG8mSrHQ
AUj3YsxQBfKq2c961dEbvC7uTHjkdlpkI8wNjEqzoAoI4TDYfcD2Ryo1c3tk
M8JgPhWO2g/7U9YCLjhY2z4A4WAiv8ycTh8L3nG32ijAPQWjk6tRdp5Dm9QO
jOUQPflzTreBl+X41oBeYYLsc756LkRVmDCxtVRi4+d3+qnWlpXvWy6rKxFR
uqsuS+/ZZMmfXAUgPIuhPAo4ILWk+jnB64BwfAV1QB79m/1jr3bT4y48KlUj
anlKYn/MLJc4jIu9T4u3I6qiLauHN7aR2FgPWbE6C2s7hlTcu70vMAB1LhyG
DjynfV5I8d1d/uifpJ3GjTyanaNAPQ51xYvMK1v98H8MCz5F7RXzJDc1Lmlu
ZxnoiWy/aI/890Wt+w3LyHt0pDtefU29QxS+ktfF5xdsWebT/0tNO+JX+PvO
SrhSoPu+iOLwmk7fBe29fqNMVa1++OfytrZ4bUW77ffEX19WKa+H9LCh1mg0
azR46eI/r51d0M5B8j/ndTe5KpgEoaI03dfJOlznpEwBIs1JZCxO+c+dNRui
3V2Gx4wfH+DpmbBU49hWpm3q4wzm0WDOaU0T7MjYXHGvQ3CxrkyTr45ou8UI
YUlQxGczcuqdvDPLAmQhk2LDPNznHL3I0MSM/X35fqMyO6Yf/v5g6AAxZgVF
yM4zpOsNbCH0CHJfXUhf1d+nz/ipk738nGOmcXW+1XtJNHBnwhOdQ6SeczaW
6spSzOXfHd/ddVA0uoZBrpERR2lOPTbxYbZn3yh0Y+eCbi3/ll6dHefr2zsy
YkpQ+07zT3MV8CJP849PmzPQXTZh6qRoX1noumTdkRHqgrtHJsb4d0E/MyXC
2zOefnzAfWDNImb9+vOc9d1qIieSZg1lP+DH2M19611hQkNRfDZimOfwUJcg
XCQi6hfH9k3t7hn5U/QPHr4bLt9neHHe/cRCE7c2B/mMHhcim6hNHiK32nh8
KmDZ2FgN9NHE+AOsabk3+n+dJx29LYZkEeW104l93NzCo6N9PX/ce1pRXnpt
z96HAhv700CSPZttQ3TR1PXLVP/eXxbv2Xd0tI+b96KNRYzOCy9vAqePGq3l
Or6YYV3cpqeeBpSpECYi1H/d2jNiiOuQ3pGRmFibfvC0cfgCLBYQ4cAhzmNj
KAtAFEd+G/F/9YftEn9rr654tHlDVFe38Ck/DejeZ+edUuS/f7Mndl1MmHmI
4tjWML9JE92cg7emab0Ioi5KXjVsGVsDN1E0Q/vwzecplIYJAIrik+G+vmHh
boOHZaBM/V/Fo02rhnn5RE/CD3pmwh28DT8rk2Lg3Hn6PrxS3b++/dx14pUF
aRMS3EQo7EX4l6R5K9whMrQABFU3ExwjTxaQPy3YPueuuUCJZN3CvjbSTuMj
Mku0VYiyeHcnsff7iPJJEdfwUD7ZUgPSw3rnHBDHhIWhXX47Xa55KZX89664
1U1PeUXkm2d3xXKKpAGrD2oRVVlBckfsK1pF+s/ykjpi11i2odF087jy5emA
ztgv6PiYRN0Euq5f162U+Z1BtRPl7UL25+izEur7yvrt2cT2vvVjt2z29o7J
pcicF0t/xP+mJ78gRbfXdnCQ6MCmV+/TxQY3ssS7bDWuZ67cToHJihSobp6d
09Y2aFXSI+JOCimaG9xi2UHaThqaY0ByMfWMkDL5vR07Jto1XmqMyCHICHXo
4xK5LBG8C5KXEd2UXnQj8H15wHFDDd7UttGYGWG+S8lfwRxDaWvaZbFxlwTA
kQmPOvI7lvt/IPWctVrX8keKcrZ2a9r6l7l35IDmkbId8zt8pOXUIzdSPcZi
PIslmn7aOvla9tpAvy1/PlaDV9w2+wtWOkdNjh1hLb+IS7uuEfXy1VEtqe+I
qZWEHs2cFp65QXxGWXxA1mIxNZDFkW4t5OvVeudLIEUJ3d1Trqv+Q3Xox9JB
I49sjfJadxC0dlSlb5A1plc7CtnP6md31/YJuSRHcM2lVbWh91YbyKeClk3A
gAp0RFW0eqZ7UzK8gxoqE/v4tPOzEZgfrguQ9MiefQ2EA/3cVYrsGK+oNNxB
yM+Y1Mg66hi9QE8Ib+reBHEfX2Xq8i516k8++bQwcYoQEaHKOhHt7J6STxqR
mF3XJvR3ylIN4Ytnd9f1HnjuuQ4RIpW3RvW00SNXU1F8vJ93o9BIwlaX563y
DlgdG2LdglgeVpIcnYCayVUZSbL62mTMUcsvimZYPixtQNGMuHk88ug9pApn
6uCRO6Z7TTiAu2ZV5TdGBbYEfKRgZVKendfdh27Bgz61YRiEwZfvxEOEAl9E
zJKMUgCi4QICIEdayFUCYGcdMwYpe3Ev9ehKT48mvXuuSD9Dz8/RtLQybh0o
T3GZzrLFJO2bD4Y4IAwOgvpyEDH1Vetli6/N+xT/VweGTlxEDozmWMlGymxl
QUSTAd0sO9IBsW3fMHAz/uuaewRNwpKoldDe9/OG9hNos6Jq3le3YByUimPg
HbLJAuRFweHvPbXuQcDahwYdvm/QZBnkxuFRDc2XpcCfOakNvFmElWzhNmra
WFXGhma9tHfS8PIKwMWUII8mgmqcdBEi90zbulbjAplSbiz0fXnBUeVBSCGp
5wLKr4DgD9O5GG1JOJgz4SsUf586ty1okK2j8/w0hish3Ae3tp6gnTSLW0Rf
TllK3JUgldnh9jMuYkIYFPt38HPdlFNjdePiglHyE+0Xpp2oCdor07cObUCx
bVCDYcX0b+s3nXn+MeXrqInbrNkGinxjcx8Efl3vhpnyu6tdvdJLEE0pgdYU
FTzwRRWSwvaTEh7EaaYmbqb3VhvGp4KWrQHYCn2yxJHStb96fFB/ckZBzT+B
Gwp9K3nJhpzkxRYdxCBj7XNHfatZ7ReS54jn4tJClwJ5k+706Rxfy64u26iO
PO6wOAQ6D1kiQES8Kf1dVt+fYveqsjLi29rZzKZE2/TnC9Sz9vBIxa+u8Ido
BfFwJS5OeVWUngr0lLpR29qT2XFgeaj7073znoIqsG8OVlp2HXsmkiiaYf8w
dXsLL07piAtwMm2ghqmxOgJX68DA43+XszIpANvOs+8Dw35y1gzyE6GgF6kQ
sSSjFIBUytO/d1yrFSQh+5/w2WkEO3/eJOSXIG1MivYZ4uzns+LYYaZqAuJ1
jDsIjKe4jAJAvQxVrpYAgxwQXV1TY5BjhRjkvxINNlEEMpVC3z0eaUPxWUh/
jbVjkqY+gkaKpAOi9UW18nleTrHijT4rEfO+NmPjaG2WaxwQgRtLg6L4j/Dw
9nWk3X6cM8dVRndDDMnCIoa+ma0rguBkRYDS2ysddIpcEPWjaT98lpimZaEZ
3GSS4GIaISHqovjRdbkbUAgEyIKgvQvQ6RrRIfx9+cDRopB4UzftyTIgUKa7
gcZbEvgmIYHb20f+SpXbA+LWzN13MVM3ZIShovR3T0eJi8ueh9paAeyeJjj2
LGt+e9xVJAJZ9GCg1kgIClSZ+8Ma0q476TMXlIfX+H+gcyVaVpDc5bPV2TW2
NFu6tcCv690wU5W+1jEW9y8AI9AOF9y8a+wHgfspz1vlEXgBj0PjDeQpUkLf
rTaITwUu2+DfQm6ljbfVKRHFdY2+gztJsmdLWQdLpZ27PC+xc+eDJN8xkJZA
3tQtANEcHxkVoR0fEdkTJiJwb0UrQlieulrWuPncCzU+hf58ofGsdYmwGpDf
h87LhXvrSMniiQ5W1qP3X6e+LzAGwPJU6etbjsMFPqBtbbuOLfAuimY4PkzV
jJWpi+2AEweCY25Ms8A4mJR4COPOc+wDQ1oRV8NbAUQo6EVELckIBSC4d69z
iU/0reIRGtoeqw7UD/9M7PCltLvbttva76kZA23MPgM8i6GCeDvL7ERnkAOi
3Z4XA6MDQrkmYBxsQT7QNmYpqkz/O7i8A6i5YOuyRfEIxhy5X/PvGgdEVyvp
tRJ935f8myEOyMv85E4OEhvr4C14MqpaWbh9a9QX5OKBy9Mn+EaZyMfiQK7t
G1bfjAMXBHarJoAUzR33pVTiujhFIyXUjx+cmTzWOSKWlulq8Iwk1gKQqoy1
TkuNUDjJXA8LIkLE/ot4X95fY59kRxSA0G/qcWdfR4gZcUk4mPLceAHGJzF8
BTxNQ71Ps+PjU+RsRjj24oMYcqGxufaOElvb+VfZSwJBPxPqZxC1/ML5Tb7O
wduPU+5rWNKthX5d/wl95cfXTc7E7D3m1GgQySGFocD9RB5m/rQK30+wRZ3d
jj4hv6DfVhvGp0LJQPNb+lWgg5e10YpOVxtYyQsCtuxkzxgqR67u/z7xEPl5
XdISzJu6BSA8x0dciwgTEYS34hAZnS1n88305wsuIqwGDtT/jRAcPUPyMmI+
0nlfba9fw0rgw1r0Q7Si1Qlfi6IZrg9TNSPy8siClHuvWJ9TLWB/WHaeax8Y
bie5tIkAIhT2ImKWZIQCkNJbiz37nNdJHiHi0qx2Iw4BNRdEqhXNLyP7/Buz
F5zwAhDyk/R8IQuBGRyQN0/2dCR/wqFJz760a2gPjza+7fCUKodpiShPlSaM
IaL9/A6I9jA+jQPC9iIiV6Ln+2r+prcDQiahOU5dqtWFSV6UOW26b32NC6Jf
ZjJpdXOzmxHBkjlZg+e3Vw4ki1LJ69pOw3pO+mn8+IAw7/auYxfFHr6Ro1uQ
Zeh8DXbDuGR+10kXtIuY9s1OKxR988s8YQpEhIDhIeZ9Bb0ORwGIjg5lVg1G
XBIAIABRV8BgDYyXAixjlYA5RxezLLnQhO3HGUwjPtOs0cAp/YODYyfI/JyH
+M7bmnil6JXWs7h/gvfr1UaY0McYoSVu3ntRsiBE7Se+Kka1JWqrqw3hU/HL
1s9lIJqw0W1ynhpqHhDtPUUWgFChu6WCeZPDEWM+PhD515n4wLqfz3NWtsIV
tU0916Gy2I2JOS+0laPBfFFNGqg6lFZ6oFurLYKzWUoXT0StZfpDgIOmszyG
CwWWwLsomuH6cANGzSioLR4zk7LsPNc+MKTYsWsTcQqC60VELcnQAhBE/Sh+
dHM33UxIokUGT0iW0GKc0oBgee1Yq/gacCT/XOjKFK4pb0IWAx4F2E149y0z
wwwOSOWz1G/IBCKW0d5UFMeFSAQ7IFpmP68DInIler6v5m96OyAvc1Z+gX6t
7vRzDEUIqrtXErt0Bq/hsfa4aKeWZAc9E8PEg7dbdc1dbTWZXyckGmx4AQhr
iSiiuHX5KfWoXz/e4jvgithB8SyRHGJDgEYT/r684C0Aof0J93MZ1J8Rl4RD
eLZqzdLAcBamO2stu5oCRvXEEM/E/xncX3MH00BYjD+WDtKtdTIuhH5d7wIQ
DVhSo4F9CxYgfj9ZrzOqxW21QXyq17LZwrZcoO5VDfS9mdJaIVvKOln6ynXu
upn8gnkTFIAwXjozG3KMZjabiMChunk2obNnSymhUW16uO/PpzgvBvNFNeYO
THGwot8aVP91dkJ7wXk4LFPYmL1+cKGgvb1smUiiaIb5w2BtjJpR0BhBFiZl
3Hm2fWC7neTQJqIUBMeLiFoS2z2UYCC3fvcOYZ7BQSQfcsooQVqM0dcQ3wX3
RaK/f3oBxweEqlSyCJqe7mg5MEcK1n9/Bv+P+InQ2Md8+1CRPKeFYAeE7G2F
g9cBEbkSfd+X/JveDgh4EfY5j8ijzJnNmH+UF5oRhyJ2wCDwjfpFFXHfJnGk
CAWiQFA02EQFIEwo3zevy0bxE5wZ06fJlrM912K5siLelw+8BSD0Ikp53ro2
NkzpZ0ZbEgAR6RWTSA9sciaaIciJevuPgUU9MSZIk7Yft5kKKhP54/YsIWKh
X9e7AKQGjKYjkfJBNFASvZ+ANhiZS9RWVxvEp6KXDU5WbHIpOaWI1iXGwJsp
HrJnLADRhi5pCeVNjgkgLMfHXGfNIiKov6R89OD65tQlbjKaR28oX2iWqmNl
vd42w154JRrYZx2SAKdDXx5DvhmLSyuKZjg/zHxLhbvzPAfNwqTMO8+1DwzH
waFNRCkIrhcRtSQDC0AqX54b0nkNW89PAcPQ+e8rq2t62mg7/kTOiVBJUnp7
gd+oWwqOT/BNF9J8Du81JHF1Sy3QqwuSGWAOB4TsLoWF7HufZwkjI2XP7z7H
W0iTleASmwbLbjId2K0jo0AaEo10+R0QkSvR932Jv+ntgIAXbOGw/RGbkAW/
q10Cg/1zRcn5Q4dy8jlSZWrK8PnvgBDl/ZuHMs6WKA2IhHMPgMB45NAg+xoR
CoSbkFiBTpwEKd04dP4V4VYcX4moBpQGKeKAx0PoYgdoDTLVQfj78kFHUVaU
noyIvPQP059wVB5Z41WX8IPQdzw+YynoaGe8JeEgM+FFRfip9aFaAAFGnUQR
ZvWENepx0CRIa9K8iZAUT0weWEq8WY5aCQblqQu7pwC9KfDrDCFTJPfU0FWc
9++0FeCmI22vaMnVYvcTpw3y8y8f7JqRROmRLmarDeNT0WSg31BpQA86vgDI
nwQ1EcjDzMnJx0Ukn/NdcPD312LyTIXyJnXsY1X5jcjuO/8iv8BiyDFei7CJ
CPWzh89oSgGItZo+QgbzhWaptN5EDF2MOAFsSxpJgNPROXGwvVpHppWJhJQk
/5h0C09lEUUznB8GxiqNwITcirIwKcvOc+wDwUeIPGXyOvB2XNpEnILgehEx
S9JykJ/8OTMo7pGYsED5vgW6tec1IFOnWP1iYVoMFKzpyiWiNoS5DF8bVRW5
sX6LrnF+TuBkc0XxgW6Oks9pveYsDGZxQAjphIKt6hPry9Su/q84dRE9mljp
QeNE2I6LK6TG8AU4IOJWovf7gr/p7YAA9SGxGrH/FjPlVL74vVsziWO7lMcU
EVD58vwQbJaixKae/9JkObNzgeRHB0oEOSCIfOtCUG9iHzRAt25LKLiTFbEW
fJ20OjcyNhUEUBSlxq/RnDhdYz7JmteRaJwiCEIroxH55l9bxOpVwIV3Cv1Y
+13wiajSgHVphAIX/L480LnpLt+3qCVYNmM2LzBvSFGJZCa3n0K+o7GWBEBE
esX1AATxNx2nFSnbsUhr90gwxm+1EqSrys8PaEvaLbgVxBInV2Wlhf52HBXs
uJxhtpRUWUcmH8d7hFK3Hd3SELtfSToX9HXdKGiV8vqIllEnue7facAZgfZD
SNHcsa2sasbKi9tPDtoQvdUG8alYMiAaEIm9swDvS6MHoIZIL1W+OtJR1B0o
H9nzXwsyJvMI400tonqGbjglwsN408F4LcJCBqqzu4Ib6CR1YEZRnZZx5GMN
5gsMTC2I6UMceMHoxYBu/Dq5T7jDq702cCcCjulN6QGZIyFFRdGMWAITcivK
xqRsO8+xD8AbpXp2HNqkWoyC4H4RMUuiihGtnG0heJm/pacfl8whU6dYJ2UI
uK+sLrg67wsbhgFzKFRll4b0YGgCQwOiKlwTEnKca2wuZTGcKlWlyI4K+fgD
rSbzlgjzOCBkg33M8A+JyKX/CqI4uCbAtvXmPEJnIfmZcXZ434DAAZfl2tsH
3DoUuo0ZhTggIlei9/tWG9QFC5Gv/9XFCrs7S3mgU5qHqOVbFjLoX83NEYr2
rr+XMD6Zrw+YBpoZixisoo6LsIioILIrGQN9GI8M/7yOdiAaSx1pLdXVy4ri
tL7tYmqG9+E2ZM3sGPWjeHdsIptwXuObEYYDURxOGvSRvgVcmPh1taK288W6
F0q/HEeZPi/0fflA67la9ninj/suwCCM2bzgdgbMIqFNhjXWknAQmfBiE+mx
ElfpV3O1tQwm4a1ksxnmFTLGb1Fz4mMpkUCO5J0Y5lozeKXyyBrPDxi0ierW
+XjfPlh3euISgSGLXpV1YnwXf2IKKnXbKb1DhX5dJ+iqytzlPpo5UZkZRGhO
K1aDy08r2VzKWHlR+0mjjYld5lHoX+RWG8anIsmAq3EoJ+Srp7TUEkSIYu8K
/w/ITh3aLpUQ8FxwCCgAYS9S4OdNKlHV9GrGwVwAIkJE4AfqaDdx7xmq9kEe
XYprTpGTBvMFBtzQ0jJ0K1+eC/XexjB9kh0gF5H6airF9dDejFnBOP1QHRDg
6hIUhWSndgqoOQ5RNMP6YUAhNAITUnzExqRsO8++D8QOF16c5EGyLYc2qRaj
ILhfRMSSKGKEpq14gc1c7t+GO3pA3imwiQ5eLUaOjWYep1vzgRbNF10i5n7S
8W9p5kS/yen8/gL/Yp7mHwj0s+7isvEGy28BoAbY9B+927stuWTWK5KKnCsp
BE6dStoa0ZA0M11cN55J0eBKoU6P1zcv7x6ifqVu1LYdaWn78l5iV4jyzKMp
KZkbXT8Hf/v8x+hzmSlH8wo1r6Y4d2yWIzba22Fo0N6rmU8Ub6r/q3h+5Ubq
mHGtP3Jecek+dec1pdYOocEHr19+UYHgY8subPHGBvPRJ/G9LLy87/z5BQt9
6mq9CMMriFqJvu+LFOYdTck8F/3j59SNPZPJcivBBJXiziy84ZWj3YTVCcf+
zHxU8Ndf129f2HQwsW/IV/Uaha7dRqdzzfwUCUfGddWtMA/wEa1WwwwfJFQk
Br0T1DUzJWlRDnVFyZkLW/zw+xqdZADV2V2DP/ok4fJThPxwadrhn2VeW7S5
qfJIosya6GSrOJzoNYOZ8dlWVrZ17jdW7I0v1IAeotzrkkJeL6gy9wbbkU35
FMXHAzrajommdbIV+L58L4QNCJb2x/eZOkmZzSrDhH/LOrGYnEeNXr+4jdSB
bsZZUjU7AQj4pnzzzBZNNMmriPLmxeUdbINW6ZB9NWvDFlV6kn999Hz/wwJQ
Y7w3Ukbm4ZOwvq0/nmLqK1/eWTnfZ1xM5lPynxDV/dhh9b+viYEgr57dXDjd
LXLq9eek6q3ZdpSipjtqjVAX8PVqwsbumYRF3pCiWyu/J9wfocCNNBvfDt8N
JdKGUU23pmMj73mJRVrmgZj95KAN8VttIJ+KWLYhfXKe5SV1JMfqIWr5vlVe
Mw6ejRwk7YgZk6Kj7thAhBFY+IYlvZMs4uNaKlvuiiDe1BDVf2XnBzou1PgF
LMcnSkRoJoZroC64m9K7XTQ1cms4X1QT0qNmRB2qE6f5jT0mOqKrTN86sDGZ
FaN8eW1iRN82MhvGtvBPsha3kH67CBQWIcrLh6OGLppsJ3VbgZ6Cjt0rimbE
fFhQ8REbk7LvvM4+eEUduJDUDtzRUyY/VnNpEwCBCoL3RYQviRQjVSjvTHEV
PIBA+c+dOdO71rUannKNS3OVFSR3xPiVnlRDvAbJzkxaDKXerNXrwz+xkTg2
n7r/tO443ZpPvihIG9z/4w+ajF2X+GfRM3I9WBXV+fkLfIeHHXsgINFEo1J1
ZQuiVtzOPj51XlAT20Hz5958zlNySdTAimyPbzhq2kxxQqu+G4B6XVIDcC9A
Ca1TQL8XUL7M2753cdCYPo5Yw1sbF7uA0b7ztm3MYewlrlYWHklbGxo9uF3f
b6zxebJBHUfERe48d5E+uUxz98H7CqJWou/71tx9UCG+65TqfvahaYuiZEOI
2dwOTXqGyGITEzLuFTJwE6IuXL8kpFm9ep4uCadYpbQqK2NGq5ZS945rrhdy
Ex3e5MS93idNh6/cWCS4fBigMm1TH2dypLiE2vTYxaUtfpoEyARjbSgupC/z
dx0UPWZM33C3gN5LDuxlGDCK+e9jXYf0juztM3ptskCrBl8Y2XZPgveQ7MPa
jRlDs0YTjt42gDsRxck9P3aTTfgpeoC758KjpxmH7gl6X95fKrq9pTf6kEkj
/XovO5+jIYDyfcs6fOS86Q695El188wcd5fQGF/fRQzna+CS6AQAZs139zrw
SHBhCaIqSd31s8wtfMqkaB83t58mHsllIvtqMFmg/rdzNtKHYqMU8suojkEj
RvoFbsnWyar9t/Rq/HT37j7Rk/DnT4rYdeU2vXhK9e/9tavCPGQTprJ+htj2
yBDZpDj6jaqAr2MUciw5HP3MT6N9xkf+IcY6r64pADn47PLu8ei7jMcOK/Fk
JoMeFL6fHLShx1brxaf6LJtIStGzT47q7pV1ASjBT4nw9vx5X9oLFRYxyBjR
1SUsynd4SEahoHXzkP2b0uNB32kJQFwweumW/HDmrgjgTYKoUKoM20O5qgDH
F0/3AcWKCHIBYAY086EYzBdgwfKbc+MCuqCfjPYdNHDPLZEBEGIpqpI9STiL
RXr2H7AnqyDdz5GtBEx168Jy7NUmRvn7jNuaUvIGFeB7J3fqOHKC53Awk4v6
YTE0I/zDyI3DYY2b/sJ318x2Oqw7T9uHbGwzeR6io000EKIg+F9E+JIIMTIu
2Mtv510B/Sif52zoSmE0VNGPCLus873KtM39nHo0bWrXKwCwLc6wvQOPF2NL
Lk2c9q0Toxmj6d/bvuH/7PuPD1q8NzmPdSAO9X3V8gt/7JgQN6Ij+FEnJy+h
Le7pi0Ht4R+oi+n1lV3zXqNYO1ozrCX37GynJm3HjRKrdCAgICAgIJgKQN5X
gHwPgwYlWwwM6wAMwQWQQs/eFh4CAgICAgICAoIVLBNA3lPgNctmTicwEQyf
TQnBBtbJFxAQEBAQEBAQELwwsDf+OwFNS9jK1OWd67L0NnzbgA/gsw4/bEjy
JwQz8FZXzCMaISAgICAgICAguAEKQN6NmL9+AC0NsZawlVjRhNSAfhG1CURV
tHpW94Zkx36sV7z0yzHROk0aIQwGx4hGCAgICAgICAgIHiCFcaG2HL3r330g
BbGDpK2bx528rZJfm9ui+eLrvIO+LBKg4sPxi5VZL6v/U2RHDW7UK1BcMzQI
gQCDwGBxDQQEBAQEBASESJQmTvfS9GrDe7OE7Dxj0QOnTAOk+O6eYb6+kZOD
vXxXMPXqeUtAdkKbGhvm4TZp06ZH4pvgQXADbyI0QNaQ6CFkL7P3DhDTlA8C
AgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIC
AgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIC
4u0Foi57mIOiWPGmNldR9iIfXURBobLWW8Wrlc/z0KXkvlDC6QAQtYEq5Z3p
flNP37dQ+kNUhZsmzL/02EKXxw0L39u3HXB73w0YzypQntziNy+pRGWUZVk2
FMXpU37KfG5ptI+8SJrdzemHnk3sJQSkHf3burg49d1wqLxWF1u6Ykr7OhKh
sPlwVqbchKupUDw8lLY2NHpwu472HbH9cQr0nL0npZCcEqXKSuu3ZLuRd6zo
6pJvvL3t7ey6OmkhMja3HP9AVfmlcC8nJ097eweZjPKBbzsn3X5t1KWYHZXy
U0O/79GqW0sperpWY47cE7G12L55eLT5yg6clAYBgceLxZ2Q6tT24HbkyCpZ
7/P/iHwLI0Ke95t3QC87F2wpNvV/+eOp2X4ZuXpwzNe4iLCp59oH3Ud0Q6z+
930nLRqrKr88sjcYh2fjYterV4+mTe0C5iaWqs22TAgeqG6eme3pFj5l0ki/
3sv0HdWHXNs3rL5E4ul7Wq9J4+U7F3YRLtVRWhoZW1Ap4vmqzP1hDQVMhMe4
CRUR5ABHUuuRANLDachPYVvOX1f8p8eL6gOL2FtT7Ayill84u3vy4rGu35Ia
quPIhfEXC18R76koPjZ0QPozPV5aBCxie7Whfnw/Y9H6uf5DvtXoqMhh2y/f
JiJdiKpoxfcTM57ovIkqd1qIE2WWIiZyA6hn1K3Rl3YB4b2XHNhb+C4NsjTE
KtCFsnh3J1uJbaNfzuoTrzAOPZjnKBHVo7gxn9VttuGuherjqoxN3uhmfv5J
wuWnlkWvxdfmfYqJwcBNpxk0ZsW/f6ednN/OQWL70bIs05jcypc5iesnfGHt
NDxo27nTjzVOt7qicM/WcI8+x/9WIYVZi+zrGMoObEAqbwxzwygzcMBlOfMv
EMdnaxt/0cKOz0Coy054N5M0049xqu5G9MRY2s3zhF4ap+ZB+Pba/phQUuvs
W3Zvnb1E4uxysMjs56wquzSkB3B/Jhy5xWS+IoVxoQ2k1v3nxF14VKp+CwlR
/ezhs3f0agnJz4xr/uFPGaVVuX/EtbLX05uulKf3bC31DOjVgEUgC8SLnJUt
MdZ0XZzCELRB1Iqc3JNRP7rXFcl0FaW/ezqij232c+IrQZeVSEHsYJSkbYZE
3NXRHurih2n9etlIpJ6zVhdVCF6D3rCsvTXSziCqktSU+K+drHvJFu9Pvl1S
hpDLKLt6YZ2fW9yp26r/FNdDv7cKFedpioZlbW+1Ku9GctDQzxvYTVidkJGb
r7lbVz8p+CN6iFvCxqI3iGLv8u4NWm9/yErKSOauoHqY3p9/9SX9T6+eZa3b
EvWptGW/3gfuPXunhJpBVkEN5KunfFLvU1mH1lImIhcKI9GDSY8SuZU23hZd
Y53Jp3ScWctA2cYZrVGnslfwn/8a9bkqRc6i8FmokNHbdcs+PPpDCbd/gZ5d
vw9N4typbl1Y2snFysttY+ZtxvQb9bUDP3SLW+btKW3e4rd7pjFP35SkumLU
47byUCXLNr5KnNJMUtshelPg2c3Fdvq+V1X5hT7O6K4Y7jjg2yvts/WimTKw
OLjmrz9+biyxCY5+UBspaYSQlEgH7brOQImoivdvMeXo9dpPVNMLqrO7ghtI
HKITioxwI48oMvaEL00qrM3MQQqQylujekq/wvzW8n3LZXWlnnM26nE5pUpP
6lWv/uSTT+9EBkoN8OsJqc59bY1ZjC3rxAp0JbCnlu1YJKsrEcHyZGyHVbTK
89a1sWENfxkVlrW3xtgZ5Gn+gUD/el80n7o37QUjT5U93tmz0/TJo7+Umly6
WtD2qv69v2BWzw/r+cfF3XzOJCAQ9aP4/p0mJwxvyCPqX2+b/ZWUUz8WXJ33
hVTq55v+txlcaHPBEKtAA4yApa2nJz65ghNGRoF+jzGWKDPhUWoih4bfGZkI
pLRxnJlUZlQpACwWQyxAwjPy8Dnzgv1Dz7IWOMnSn+v5EyxAFIeThqIGyahR
l56ynziiyo0MtDGp8V+YGdeEk3jI47OIEL1RAbhbz/cCYorNWhaxCHx7TZ3j
R/1Bdq6pTF3haiVxnpdcO+mRb0p/lzlgdyD9wm7RIhVVytyfOoceYrwZeTtQ
eWyDV2O76IOZRvA/Xj9O/tqmdi6qGIHzApEDgKjL9KtmUj5JdW9lNSL6fnk1
cv/ctKYsQT8BILQt3/6UJAR/tp4vmUqD0luLPUfO8+mBadqgiLtCtLTi4ea2
NlwJjaRoFfpAvWFpe2vwzqiyMma0ain18dyVy2Xrq9I3fv8BT4DRCLCc7VUU
H+/n/9EHTaP3neZKYCP8O66oo+aKn1s/yldPRS0oI8VVLAIGWQXkM4rmhlv/
X+vNecpq9cvTAZ0lvkGXX+nzICOJMhMepfLwsk6TVk5vjjErf25qrQCoSxP4
RyUJY20NsQAFmtZl91bKjHt3Q3gfHFlPNR81AjtwAdicEnv2q1ji+MwYojcX
cO7Wk37IO02DVRvQxWY0Jtm5pupBdB+bWo1jEPKW5o4hqqKVUV4b08yWLW/h
ADJBbP2C6QByCA30W8t3L3Spq8kQQArjRlg5tEt5LF7kaHJK+fbnVeKILqnC
SB1RPZjWJfTo07/wxCGB4SAiesnF2mQap4kvly1tbw3cGVXWyamf2Uj+57zp
Dp9VB6Qrd4DRYFjK9qLeR4CnVGodnHyaL9MTE/VSKWetH5Eawaf3QSCOw354
22CIVUAAT+zXOKF4cZDViP23RD/QWKLMdEf58uFv3b1//6sANxFrL3TJCULa
GJxTR4daccbfUdLii/V3lHo+AUgn3nMpy1va15i6HlQySlo0X3lTgFeMUYXB
YXZWELm4HNlxQrLU3koA7tb3vXAz3giWg7mNSQ6uAWKqdlXJ85yVrTB6dJiy
lMzhQeSbf/560Z4y6H2QwO9tzZG3IxA4Lxjmt77M39zOqtVESvDtSdbiFlgO
wwux504ETLijuxherfEfe17QtSNyI9UjLO5RBZmM6iLoQpw/8ZhMfzUt+1ve
3hqyM3hFpA17pZg2sHz+xlZRpry7t5DtVSmuh/ZGv+w4OaFQwG3aq8TJdVpz
Rr3wdFx+/UiclKWm34iFYVYB/gTV/ZiBVv/rlPo3qUarlNdDuuuTmGcsUWaq
o0SKErq7p1xX/YdXzYgojjMr+NPP9APw1wyoK2HNr1MUHr5I6eJSeH5wvPE8
u9LbKx0wr6f7yoOCnll2b11rkxn/pJznyI4jjs/EQaRaAOBu/cjSeGlpYHt5
JYzRwME1IBnP6IVa4kB6xIQfhCgOJ3rNMEuV7tsCw1WkcWGM9eAFm3SnmPEf
+ZdDSHWd6G5V+Y31mynZBVV3o7ttzRegLytfnhvSeQ2+DOK+WEgwjRQRHFFB
5MbhUQ2xpeqdIi4EFre3huxM5cvz/T1R+eDwI+YP8gOr1LPx22bCu3vL2F5E
vnl217qoa+yy56EgWfl6W7zNQK4CEILUefW+mjA+zafCTApDrAIcSF5GzEf0
6BDjP/I/ykiizERHieRfiPKOxDqmmi2VVA+YrIKg6uy2gA8Mqithy6+rOrtR
tsU0Igv1jmNDv5SKaZ1Udm+1q6kLQDhuWARlD76VwMMCer4XeXdmpAIQ87W9
5eAaIKZqPYiB3E6LbITRZM+1aa/vHfDyis6tTYfI8mCWrBIRAEEMQ3IIyYJN
esQY/PvUpaI4lDVruvD8sN5azI68LnstgNTL9y1ov5C4gCP7AQrwtggRwR5O
VBQf6OaI0rl+BftCYYF7a8DO4C0OsHaaS67Tm/kwQ12W3rPJkj9N5qpbyPZi
dy5ioprYDUh0k6VcBSB4Oq4A/ai26Oi3aBhiFVQTRbsMlx3g3791/71IxB4Z
SZSZ5iiryq+HtZ91CbRFJRMmazl6yQSygkCUqaYuuHtkYox/F9mEqVMivD3j
j14k0r+RyuyYfngHYzBbpKaLeMjOM+ISEtjy61BSieow/4ZJRBbuCLM3VWOE
ouj4zjMmyn7n16cCsweNAeTF4xMxk9x6+USPH+b5c/ydf1QlGdtPPKT0hUPU
hetne/aNCvNwnwuaOP1benV2nK9v78iIKUHtO80/zdEPDVFeO53Yx80tPDra
1/PHvTefp6D2tr4FIMZKSwPcYd86ObsgIypUFhod7ePmnbD0fhnDoliZgn+5
QrgGXD2gG5L76kL6qv4+fcZPnezl5xwzLfsf9h1S/nNnzYZod5fhMePHB3h6
sqxcHLCeHlizU4nzZ17RE7JfmSuspig+GzHMc3ioS1DwqcIKlNheHNs3tbtn
5E/RP3j4brh8n4G01MrClN3x3V0HRaOvP8g1MuLoA3obQ6To1uYgn9HjQmQT
tXdSJDFXpm3q44yeWA/Qpr6mnbtmag+AUp41f+5Ad5RIJmG0FJ9wR88NRJTZ
l5NDhrgOQdeD7oDPipOZ2vSGFCSMwzvJ4zMdHJr07ItPYPhlqchyVK6cee3s
eiEgtK2uKpSvjmirR1hJfne1q1d6CbmH+adiGgpqOEmIiBYs3QsVxRlDgj6r
2ygsaU+JCVuZWeLe6r8zYLCCuIw1RPmkyGR98yxke7H+5LYScdn7SFlREUeh
iIDemARA53aTOSBvkVVQzV3uoV0YIgBGEmWmOUpV+lrH2Bq/W1RuqlkhMP1M
A0RdtC6hRzOnhWduEHJDWXxA1mIxLeIBUtkNyVdnzK9D1PJ9GwJamCq6WLp4
Inb98Xmz1dkWkT7BX8gArkhM36MJ62pi32jwZqLQWJW+pmfHsB4faPEClok9
Fku1xfJXP22dfC17baDflj8fg5EQr7fN/oLt1htRFa2e6d7Ued1NPDCB+pgT
+/i085M20NODENQ8TQAIXdy+1aCfQo79hVuKmPn9YefZ2qE/gUzBCw6uAWLK
ttGYGWG+S5MegZlEGI+wJjOrbp6d09Y2aBX5Yaz1R3CLZUJDcByoPLLGq66Z
2/pR01k/lg4aeWRrlNe6g6C9pyp9g6wxveIVKcrZ2q1p61/m3pEDOwkp2zG/
w0fttt+jUOCzu2v7hFySI7hs17qC15uYQQEIs4pUFB/v3WL0/msai0uVvq5N
9FLRAXaVIjt2bNPvfPbmFhLzVgquzW1Rf9iui7q+haEV6Nx6GbM5razCYwXl
21TXaFvqepAy+b0dOybaNV4qmtlRqvDwSL1dszTenoEkiOgl3XhAlI/yryxb
P75Vk55TI47eLTTtOBuL3Fu9d4ZoaWX4vbOxYCHbS7a0MmYlETDbhOh9giNM
0gHp7bIKsGm5A13ZG14Bd9V5e74wgjCWKDPFUSqL9/t51BS5CO7WZX4Q6WcC
c+qw0ZzTv63fdOZ56uzIqrsRzZpt0N4Tg/PVCdtPaxIrMS/SVOlGJEVZykUV
MEfpwzGpIEdjm5iukNyzsZ9pG7q6ndOQyuxw+xkXMSYCfZw6+LluyqlhddwQ
YtRNSOnaXz0+0EonJnpY1XYBCOAOG+3m25ggbUKRmcKZghccXEMm43ku2CbX
nAK4k2VtRGMlW0j5MHYEG5r1MkYWKCkJbcfFFZqnu6Mm0E1cQ0u7L6WUveOh
IUcKfSJFt9d2sLaeoJ2IjvtrX2rK51GNNsEx8mSB5o1q9KbexAymz7DEc0oX
T6g/gDL0SlGcNjCwoZtIIke9j6hgaydaMjlSEDtI2snt6BP6isAUGz1tQgGZ
CcrDa/yFN9IH2lZLqpNCTHy4AMk7McxVe4gYGSTk0dGa63XPjpN/DdLGL+Gu
zl2iI37PyjHtRBvL3Fv9d4asDmO7OjEzLGZ7NeOTjJilQJhtAvQ+yOk1RRbx
W2YVkLNgotLYQxNY/a/g7gRGEmWmOEr56kjHjVr1LEQujdE7TRkKwelnODCG
/UCnEXFZQXKXz2hXBoYPLGBy2RBlXlZS5/rfmyjdiDSrLCVbkn+SBXF8pm3S
AuYL06rngB1I1TXPsua3x/mOmABIL+nCSYLhXcCYTnrRIp5KoacHYbS+xKAX
onX44dvUNeMWXY2MFc4UvODgGkJM0ZJXgcusK5BBIwWXTtQYCDbfatoPnyWm
GVqKiJrNQ7wmDwvGfHVxPe4Q+eaZTT2C9cj4rrlQBkxB2wdgdmocN0aKrSaJ
VnMNLc9b5RF4Ab+kwlusU/SmvsTMNSQLOyyrxlTZ8iRrhWPD7kuS5SKIHClZ
PNHBynr0/uu0vAWcLHVSjwybYiOoNhPMmBY2TZi5qTiiLoofXVdsKyRV2aWQ
9gtol4xMYUkGcCceY/fsG4c2kHabHMuV32gYLHRv9d4ZMkHdQubhWs72Etkv
xsxSIOfUC9D7RBKF0UOUb51VIOyshXcnMJIoM8FRFlz5pduwG2XaPyNkYKL5
IaqCAJvm46A1LB4VRxfOb/J1Dt5+nJ5+jO2qIRkabKZ11d1I++kXTbKHZKTC
Usa1EA4vfwGIaRtcgPE3jrSwgG6zpqfZ8fEpcjYTEURopTr0DwoKdLqpALmk
nwdhtAIQ5updQmIQRCKCKfgXzs41RAEIXZ/iLrMOjyBFc8d9KdXKPVA/fnBm
8ljnCIMNKszq+/rnc6V6VEuBEWASWdBl8deL5cfXTc7ELpgAU9DNSxA6ID0L
QLEMJig4UDIKhDzM/GkVTrGACDtTrg/0I+ZqztGrwEty6Zh0U//EHmLbmWw8
oJ7ossuQCvSqiuzwAKmn72m+dhyq01v716f76YxPZMuarspY68RVcssAbMDW
HK0LPgzC6jT5RQQ5YdZUE9wsdW/13xkyZdoixt9Y0PbS2gYaA8L1vqaLph49
hznx1lkFysOJftaNfjn7mOegdZs2M8NIoszoR1mlzI7oFHtO5zUFF8eZFUBx
c0ib57dXDiSKKAn7vFmjgVP6BwfHTpD5OQ/xnbc18UqRThWl4QML2M6lqvz8
0K4HTJNuRNxScZ5RaeK0bynJYBiw6k7nSUd5JZho8BeACM8e1Btg+LWOKGC2
A3EAOqGzCYshRLRUossl/OpB31RPo6U7Mpr3RF4c4SaIYApecHAN+JNObgMI
wtB5hIxhdhrWc9JP48cHhHm3dx27KPbwDYNTSlSK7BivqDS8ZhDk00oE94tD
PZfggM/q6umAaMA40oJw1YEuAK/PyBQsg5yA0cUo2EURczX36FWk8taonkBq
2Hs6hc+OPpIr1hMhjBkGviMyZ3R+2oBe6CLmc/EkV5Ngv54omd910gXqeSHy
fbPTCtnptezxLs/mbj66WamgjQNPw0khneeJCKdpEoosdm/13xnxxc5I/rnQ
lSmvTaDMLWl7yQZEwut/K+V//Bh5ieMWSXDhJ6GehDclE4i3zioA9T5jBSUM
C+pOYCxRZuyjVGWmjLS39/amSUUXl7Z9v7G2oOg6AG//4crUxXaziR0GN4mC
7r8MH1hAmNY62W6VLy9uPUSPehkJ5A2IICeR7E8lqo2GGBBXllwbLjx7UG+w
jMTluuFiNBFB5Fb3XYCTRf93wN36lZALHk7KC2bzHlh0pM8ugil4wVsAQvsT
SHLWFcgg1mF0qkBUhfNDO2+pmeFL1pwKUfRI2Y5Z7WftSWxnmAPCUqRPpSKC
YpksKC0/hbI2tuuMapHEzF0AgkFRfDJ0tKs1EbqQfN5kXGqmiPg64AtGbQVa
p+r8NNeNDDdUZRf6CTDMND+Em3wDt1/geh3WCnFEcevyU2pLpdePt/gOuML6
00jJ0qEee+hJaDgENJwUViMmJB6lJyx2bw3ZGfHtXl8k+vunm2DAioVtr9gG
REheun8MV5RbqN7H5uv1MMUt3ttmFSBlW2eL6HgGvJUR0ffL2T9jJFFm5KOs
KD0c6LGbcdAMGR+wpHEwRDyNVdqg+rRvkzhC2QHBLqiY0fACEDOY1gwgai4E
ZY4Za9A232I4NlxE9qDeIA6CFk7kiNUTg7zpYUN6jj0Aqe9oXjmQb4YVgBiB
0dAjbqBjlwKr26Zf2C3MvBHBFLzgLQChDwcBzVUYroAx88DIVIEV2k/otOKg
VlKZpusmbxJ1wZW4zn5niov3dDTMAWGM5xP39dZRx+4jZAiXiXgIfqHnjIFt
ZGRkUcRczVkAQl1H2Yu8o6d2j4xyrytSgACtxyQVieCJjtEFdkOPqBco2BQx
gI+twT4FzFnTTCjfN6/LRtbs/ZoBW0zgt/fIxGNutiU66ZngBsRy99agnRFZ
kFh6e4HfqFsKAZ8UCUvbXiLuITAhpEqZHem+JIvDdyL1fjDXmELsc2BYpKtb
aoGRh8+9ZVYB2ywYdvCSkJFEmXGPEpFvntp5A8tvWeA4GPIWiU09ITcODbLX
6EdgawkJB+k4whWlJyM4rxTpIEUZ37kYGaSbye86kdcTRk+t1ICwKGq7AARo
c8aUe8LsrJRfjI/P1lQ8MZqI4MaWzLHX5PMTTKET0cWtJiLVE3mYOTn5uAhP
1mhpaTjB00vMQP6zphZDOFPwgoNrmCNLeC9cbBogdvrK4uMzloKIDXBAjCpn
WMedg0xgnnthLPmqzU9nHiPqJwY6IECV0wieKIsg7QdAsQxMATxTnap50FKY
+PzLB7tmJNWEmEQRM8N1A1K6cej8KzgdVpQ9fK49ggWYPR+LaUsC7rYYYvss
JUKclztcEFOcW/NjeNlvwLo0lvEFZDI87824svhA9857CljIFx+wRa89p4Df
NhDSeZ4cdsPvXIuFJe+tYTtDXIkKycmsqsiN9Vt0TeCsXzGwwO0FIQ7dqfGM
D0jf4Lf6IFfxoMBx2GBY5Oe03ozGwdtlFegz9R5Q0cAwFgfZSOxm3KN88uds
Gb32nLJko2WGGA3c6WcVpacCO9nMrqExnACYbS1V1pHJx8kiCJ28vvJ9i1rG
ijHUzWJaM4LwNGntg3Q/RlTgmnAOguAJIKYd0g20Oc1FLd+96BsyN4nWCZNx
kLdWjn1V+fkBbdcCaQCYgtYaDiTlkkpQt6GckAUb4+4MN946asdRsYG2Uqpc
EsoUvODgGsbIEtg60pxGMpPbTyFZjNZRlgpFUWr8GrGNc5XpSZ2GsYw7xzvt
c3viysPL2/2ahKVNvjHUAcGZgrbbSNHcsa2saporMlIsngO2SFZXx8bg2Eax
xKybZvAka15HvHXwy/zkTg66UgXr5/ytmIwCoMd1qxsKrs77QsqgLoGCE1+L
V75v2Xf1bOMvPhVZoaJ+NG0429w3of2psDjery3Y9YXqbHKXX7i0CW/DSQGd
5wG1SCQtmi++bmQj2ZL31tCdUZVdGtKDyRGmPUNVuCYk5DjH+Dn9YZHbS2wa
rzOryjoWEp9YxB10BUKAW+9jnbpDPv6g6bQTJtnkt8kqwFX2t/OTy0QGilUX
dgWzlREZid2MeZSI6sG0LuNPcni4ZG4qZ3GcOUEIakZTDXvr4Z/X0YqEgCiB
bgsCVdaJ8V38Tz8l/5nWErPs8U4f912MaWlsIPLrDAgso+uf/uN3HTw33hSr
PrDu013rShxGR7L2C8K69w+XfWTDqdkRxbHt4zs5h29N02dIunELQPTfDcLV
onqCSGHWInsbzem83jatLeXWjzHV81XilI+lRPyHJprkq6e01CIzRLF3hf8H
5HtpG3gCYMy+xJWpy9o2oGwv6KzSQWuSnVCm4AUH1zAWgOCfJzQadZ5FNRm9
0b09ROm2b7uYU/dF0YDibGrEN33O0+eHkyBb4rD67KW3F7v7nQFfN9ABIcr/
tfJDkPzMODsr2VzKXMjnOStbSb+aq60aMBPdSjZb5xKHto0Tu8yjhNZFEjMu
4TXRY9SkiXfHJieiVJyR5FW3Xs9f4rScOCxT/aMOy8XMhcTL2KXdtO1DzOrz
svLRGlVDQFhKGB1iCjbp4Bj9JmhEIKI4nDToI/YLtbLHu7u1WcctEMA9Eesd
KG/neWwNQxtIJJ9zKH19xbsl760xdgafv+OAuieLLj1mbrDwb2nmRL/J6dyG
8Tu3vZhBNeJLqTRg5R4549oQVcnOFX6z+LwPTUIXu95HnuYfCPSz7uKy8QbL
EWiW9O5bBWC2IItfyQ2O7gTGYTfjHSVWe76703c87i2Rm8qoDgwgBj2hsRxo
DpG6ouTMhS1+AS11Z6Eiqvuxw+p/P+CynFgj8urZzYXT3SKnXn9OYRugJfvj
j6W2zRG8srKtc1FX2pCZKUQrDyHJVEwLUJzcN7llvXq9ZCuPHnr4qubV1E8e
XVm2MkQWuPNO2YvVP304gP3EyZEi+hWJII8yZzbjbFmgOT4Blf4G7UZVRW5M
sGZ6mvrhjWXf9zmavjWoHi5qVNoDN1myQFXpSf710dP8DzOWxnhvpMwhqn6W
l9Sxvj+ImGFN5ld5zTh4NpK4etAMURUKcuascRKQUGvHzXbkIfwWAyuC+PmT
T1ySsrU5VCBT8IKda5hrQzAvo2WdWOw1VZm7/OK0JrOrzu4a/NEnCZfJMKC6
ojTt8M8yry18cowK9ZOCi9Om+9bnTLtVKx/8MvZLjLqkAbqZA6jLNqZNjWdk
oAOCm9M2vh2+G0qkjqPWzpqOjbzn0bQ2Nm2kRRNNuiyivHlxeQfboFXbdFPI
uLZRPDFXHkmUWQOppZ209vLhb929DlDTd5X/3JkT3W46Q1YbNzCHq/mHEw7f
ArSByIvPhQ+yHTrsHNOD9MqaRuTrZ7SvYz1q48bTp1PE41JK7+7S5roJD3xS
XV3x/MqN1DFYXQxboFhdkLfXz1PammdUMR66ZO+NUFaQ3JEt8RipuHf76Fhs
DfY/+O66w66L9RTvlru3RtsZ9KMvCtIG9//4gyZj1yX+WfSMFDiI8tGD8/MX
+A4PO/aALZxB4p3cXrXy0eqFfW2k3aLHHb2VoyCVGlImz9tzYF6Az/z0TH5v
i0PvI2rF7ezjU+cFNbEdNH/uTT7t8z5YBaDxu8O4iJOZetDDxfOzZsnqMuS1
GocejHWUiPrlyYNTPpM2GBP7iKtARP1o2gi8jS+DO2aYwSwOlWmb+jiTExuJ
LrL0Vl04yPRyKlT/3l+7KsxDNmHqpGgfN7dJEbuu3Nbt7YkaBlt6uw6KnjTS
r/ey8zkCvQ98YYzzvr9efk1cDrMq62S8U5MWXds1m6Pvfir/ydm4ea5/aK9W
LZp44JMuvVzHLojZe+l6GaB8leLu9XzWV8NuSfyaOLvbdSUmnQnC85z13agv
3rNHC7uvejo5DQoj3HCUaKeFaHdX62jfEV0e1xYZuhv/lmZOHus6JGh8gKfn
TJwdEHXh+nmdvvP8aZRvfAbFu8SGYtT/do6WMYyvQJH9y6iOQSNG+gVuyaYr
L9XdK+sCUGqZEuHt+fO+tBcqbPcyRnR1CYvyHR6SUSjARKPvm7e3vZ1dVyen
bu5b74rJ/NQBUnx3R3+3gROnRnq6Dlm6NOcFkygQxhT8v8XCNeX7lnX4yHnT
HXogRnXzzBx3l9AYX99FG3XjZooL6cv80aeNGdM33C2g95IDewsF97ssTYzr
1bxJi+4aKSHtGDxSNxBUmbZ1UNOW0o52vQLQPffwaPNNE2d77/6Bx4uJH1Ie
XtFm0tIa69cwB4QsADn47PLu8d19osdj75V4kklrI6qS1F0/y9zCp+An8tNE
joa3rNuoBzFjcSSUU3pH9vYZvTaZ6hMgT/OPRoZjf4okTiTxxBnmWCgfVHk3
tg32dgsfyfscfdrmE9dMBqLmR3Gp3qNHq24tcQUnsann2ocm3lHK8W1Xh/xq
s0YTdFqaV6ZtHmJPPgHXWb0Tddq3IpXZMUN6EOIab5PerKHsB6dv4xOxE3xT
ejzoW2r7dHsZrVll3x5NG7bv1XFEXOTOcxd5jkY/8W6Re2vknSHOQi2/8MeO
CXEjOvZo2hSXD15iOoG/S9tLW+Pj+xkJq6Z6DvNs1uSb3ugTnIfEjFx77DCv
cMb7/1PMNpy2Kej1lV3zXqNEdIB/960CTbcEw6CpRDYWPRjtKDGJF0Z0Hcdh
L2uz4qqOHYhZR4E4vRHLs3FBWdJ52smaXAgjGMwQOqhMndU91VQ1GoLw7M8p
QcZo0GoM1P5uQLxf+C83NohBOAN5Gxh0ulTc45gKQCA4gBcx6TtMB4IfliTe
30HA7TU9oFUAoQEkBmOiqvzSuL5YBWjtoXzPtL6m6HOuByxgNyDedzy7ltBE
3xsQlgkgEKwAFeim6xP+3sOCxPu7CLi9Jge0CiA0gMRgVCA3Dny/UkyBp9Gh
LN47dNQNYbOQTI3a3w0ICEMcEAMmer9f0PT7xXeMuagWwnBYknh/BwG31/SA
VgGEBpAYjImK0kPDBp/jq3UzJZCSFX2jzxq/Bbc+qP3dgHi/8SrvN09KRYl/
W5dxsbli6q9BAYgZSuTebmDFm6DfL1KZuvx/1iK730MIhSWJ93cQcHtND2gV
QGgAicGIQFQPfvVfeNVc/cSYoDq71Z97nJDZYAG7AQFhGJDCuFBbjqZwEDiQ
zN1B1vX8ExKLlOWXB34kW2UZIuidgwWJ93cRcHtNDmgVQGgAicGYQOTJM0w0
5EjoCvLPhU/lb+htFtT+bkBAGILSxOlemtYieMu+kJ1nID0zQ6W4M3+K76Do
aF9Z6LpksT1+IYTAksT7Owi4vaYHtAogNIDEAAEBAQEBAQEBAQEBAQEBAQEB
AQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAUGHRGKm/0BAQEBA
QEBAQEBAQJjHNYAOCAQEBAQEBAQExHsL1a1Ts8/kwF5rALXigCB5pxZcgtO1
ICAgICAgICAgzAW18nleTk5O7gulmY1QRHE40WvGajgXQIPauQFRFu/3c9/1
8G06BqTsRT5KswWFSjgCEALinUetKan3HhVlRbk5Ofn5ZaraXokAQL0AAfHW
QJ73m3dALzsXG4lEYvPhrEy5GX8bKds9v3Mc1ftAXiTN7uY0QNbQBp/uJrFx
sesV4ETCxaVt32+sJcSf3DodePQOipjaSsEq37e4xfiEIjOqGCTr2MQOTmLw
9fJrGH2qTm0PbkcSiYfPmRfmW7M+eFN63KczQdBCIOt9/h+eR6qfPLqUuHmu
/7Dure3tu2FbExA5bPvl24TORVRFK/sx8vLrlOVeTr3cmtt17aW1szUjFIuu
LvmmSxdHe/su2ns/Kjr7X53HVZVfCvdycur1lV1zH60HOk87eR+aiRDGQW0q
qfcayL2zMzv90LOJPSaXnF0OFlk0T79legGi6Orcz0QoRol96+0P30GTz5Kh
fvbwmRkCPmX31tmbWcIgisNrOg2MzP6H4RerMjZ515FIWnyx/o6S/jd1Remx
g1NQunWRpT/X+aN5tsuU4HVA1AV3j0ycIOvXOzIydoLMpd/suKtPOW8u1MrC
fQeWBAa6DA8aHzDcZdiwjEKmX5HnrWnXYoPuhpsKSEHsIOnHjUJXLb1yP+dF
BXFqlakrXK0kEkfn7fnkS6krnl+5sdPXU9rgo2VZrzXfB0Ri+2NCidpcSzYM
5bsXfWPFQtXoW5YWZS1fNqiBRNIr+E9dU1/zsYK7RyNiPBs0Gpzw66k7OQrS
YUTkxRdjx3eamVj0BlHsXeZpy8nLz24utkMFurT70j1l/zF+oupuRE9M5vcM
vPCCn6EIhrWpPzmjgPfDQvAOMDIEFUY40FpQUu8uKsoePi8Tuo/5p2IaSiRB
EXfNfkOuB9mYSC9AiWQqIKpbo3pgusY36PIrhr+jmvH2xi3jPrGBvG98qBQ5
i8JnnWIeN686uyu4gcQh2uRxaST78OgPJTYjYwsqTftDGqgy9wbbuexhyfkp
2zijtZTLEitJGGPlR/+r2bbLpOByQBBV0eY5nj/GXix8hZD/Upgw4cOegeef
MTMmUnx31/etu89dfEf+BvyLKnN3p++YfgWpvDGssWzjaUZSND5eP05uX3/Y
rovaZ4V6JYNtJAykWJWx0a2hlvzBiUTaZ+vFtyUmUpIw1lbC7V/gTll/FkWP
nv6W1cMbW303KfqchgC0P1A4P7Rz3NrJn0mlwdEP3rCuBPC7xFbLodOCuuyE
dzMs6jkvuVwAPbzeNvsrqdGMw7eTkRFFxp7wpUmF7Nv+LsP0iswwJfV+nw4N
L/OTOzlIXDql/i1IdoKgkEBRYERwkA1SnLtzwoSThQyC0hR64e2USIywPEZ4
U5Lqasura+SrJ9d3ZIg5QxgCJHNXUD1Wb73y2AavxnbRBzNNTfXAfnBbeajS
PBLmWV6Sy0eRx+6xGM2oJeyGEqTjzKQyFiFSlbHh02C6JjLbdpkUrA4IllcT
5bUxTUELWWPRbGnPtWm6Z6fKyphh32jw5pqvILl/xLWyl7gw/8qrxMl1Q83k
hCKZ29u0Cb5Rpv2vpCxiIMX8k+FOFNMdEMlblI+hVpzxd+Sm6mpM1y9pMjXx
le4HVIrsqOGtrKyD1+8p4dAd8rx1bWx4hTm/v0BckViNOcLCpFSQDGusCMZb
ycioQ/31+xujM4MiM0hJvd+nQ8fznLVODWW/JDwoF/RxPHIiTBQYFexkA+JU
TEsyjV54KyUSIyyQEQoz45rw6xok+6Dv17VwB/duA2dt6aBd12uTGsxsy1VV
ZIf71h8f94iNlhQPN7e14SZIVjvt7QebA6I6m9x5bNwjpervi5e10mbwzARd
2w8pzFpkL209dSnVJCjft1xWV+q5gPlXKlOXfdSBvwDBGEA1iKzFBp3bFiCL
mEiR7nICIrEoQcoNYSZ9VcZap6U6JhbmfYz4UsqRMVUDfmtBgL8A7ElJixa/
3ROQxwCUGqPb+N7A/JfIFgWTKzLDlNR7fjoGoar8Qh9ny0q/B3EqxiW9dXrB
vLBARiCSrnkJLD/dK/itSbd+OwCCoiw54eYDYGdz8awqPcnHhuuV+fNDsFj9
BLsNZyxGIBoTzA4Iqn9HtJpz5SX6v4pmdZtzg7IzuNFOFykVpb97OjJcsiPq
Mrw9COOv6KY5mQpvSg/IHHUFTtXZbQEfMEfmK1MX282uiepboCDlBvFqfCZ9
Vcaqbju0rThE9Shu7JdSic3AsFsK/h9CvcgO9TmFuQB/QUC2GGWBgGHfotso
EwAkfgRuMlcGo0XBDIrMMCX1Xp+OgQCRE2GiwEz464+fG0tshkTc1TEQ3jq9
YGZYHiMQSdf8BJaf7h9n7iTAdxwWwtqAnc3Ds8onqe7W/zct8QV7IJfID6H1
AlIUndh6/CXxLaQgrkvkSeOUu1oamB2Qsrw1HYkEyJIF3WdRHBA8gEATKUjJ
4mhUznRfeZCNYVkckCTPes023DV5lAHJTnUfyZBPC+xeRlIsSejnuL3GMjd3
0qDBIEx6nQ5XqpzDhymZzOXJgwef1zLjlYfX+KOey+efLLn+UsgPVWVsaObG
JVJIf6H+L388ZXkEHvPkyxbTgAhhvc9RRxCf54yZvMswgyIzREm956djGMBl
qPkLQDgABA6j8H/r9IJZYYGMQCZd6+qa8pPLjxTW/BNDaA7CMICgqEAtbzpw
sLPRUb5v2Xf1m63OZqd/Mj+Elk6MZG53HPNeXMAxOyCV8uOBnZMfKBXnDvYJ
j6/JXquUp/fUuel4krW4hY3EsV3KY1bCql0HhBlklQQ/KRJEUmfyqSdmWpuB
IE16nST5qgdTZRs57kRAuSgqn6dz+exaT8xYZz9bQAEIx5U3aDckNOu76kF0
H8a+Ae8RQOLH+9r50wyKzCAl9X6fjoHAY+a1UADCDkzgSKVM8ZO3Ti+YGRbI
CGwFIFXl54d2PUCNaKlfl1WYhQYRdeH6eN9BsWEe7nOxrhqI8tqZZQGykEnB
wf0jPfsP2JtbqlkH3pI0xr+LbMLUKRHenvFHL9JLdFEo5Vnz5w50Rz8zKdrH
zTs+4Q6lhYzq1vn5/p4Rni5dF20seoN9+Obcnz37Bo0PGOQaHZPJ1OBUyI8i
T/OPT5tD/KivLHRdMjHtAqnMjumHt8oH7bWlHf3burhoteJHim5tDvIZPS5E
NnEarUst8aeBQ5zHxlD+hCiO/Dbi/3R7CmGbKT99PLFPoMvw3pERkZ5Dgw/e
p/VLAuysnT6hUmTPGOMzckr/Du6bbpZqfV6luDknZN5p5m4nPMCs5dZSbkOF
yA+hpRMjBbHdWm5h7mvBsV01n3ma//vESW69fKLH+/qiB12hLsnYca3mcBHF
sa1hfpMmujkHb9Wu8kbURcmrhi3T6hqhunk67vs+E1FawmkGefE4IypUFto/
OBijh59TT9c8QfnPnTUbot1dhseMHx/g6Zmw9D5f70O2GhCkOHdfTMSCA4ee
1qwEKdux8Lv6TaedoB4HUjR33JdS3NZVqeVnTm6MjA76KSIp7XDh65oPsRWh
16lTew4IiKNyROY1AESCmtD3y+6vWxvu6xs9aUaoi/PEXccZ2J8EF9tiMme2
Z98oUuZUV/9benV2nK8vyjVTgtp3mq8fwdNeTTdJXp630nvYDfa4sXz1VKwd
nK3t/KuCrj9QqG6f3pxTyr5Ysr8ue7yauCIRWADC0TdAJHgZWf3XrT0jhrgO
wRpQoyc1/eBpjuPmgbri0eYNUV3dwqf8NKB7n513XqnuX99+7rqoB1amberj
jEruHj1adWsppQwtiozNpZX3Cvg5VKrM7OkZMZSQKtWIqiR11/TvfUZHT0fl
UuBS/B9ZwCffNJ/jVAeK4owwT8+R4W6Dh2Xgt3KqvOvJI/r4jJ440X+I81Di
H8lHGaTIah7z4vGJGLDyYZ4/x9/5R1WSsf3EQwFKig/8p6MoPonKjjDyff+r
eLRp1TAvn+hJuKyeSbEThByfeENCgHZAFBkH47/uJG1tN3E3Kdwq5ecGt19O
D+IhyuzLySE4d0RE/+Dhs+JkJp2YgVofPTnYy2/rLRYRQXvTnBeYSa9PAQhQ
qdFR7h1H7dQWy7gJMeP4dUKioquKCWv0Rbvt94j8PWayeZ6zvhtlFlizhrIf
8NPs5r71Lpn4p5de4HoHNgI2TF+wGocUGFFbiRBTfPJBKL8IBpGZrHMpg+Sd
GOLO1cjRdFClr3WMxipnMXPoU4flO1d6xSYAxixPXeNfnwy1oZbhuoQezZwW
nrlBjN9SFh+QtVhMS1RQFB/v3WL0/muasZiq9HVtopeWqomv4AOgVXina2ng
yqP7B3utuvZYjWDyPzfSv/6o6Fyqmhb0oyjr7Qhr+UVc2nXNj8pXR7Vcpp0P
A+K9uqz97O7aPiGX5Ageh9ROrXl2d13vgeee6/wJqbw1qidDEBJVKEMCbIcO
O1VAUAZy42Dg19qth3RzaxHVg2ldRhy8pUIwW0WqnWlpSEc+5Nr+YR9aRx3j
nFAGWo5TCRJRK84dm9q88VLGe0OO7SKhysqY0uKTn4+B40CN9llfe4T1+KDm
LVRnk7tEJ6AsVZWRJKuvnckMTEdq5ow8b/U3Hr+j24XTzMAVKcu+D9x3D+fT
JzdXtLHXnKnq5tk5bW2DViU9Iix/1DUIbrGMNS0KQOAgQkRefHVugl+T5nEn
tWUd4cFZjUm5enryqA0Xr2Pja5Uvr0cOsh1RM3WF6VfwHrAda63THVH4LCCT
h7CQv/smZpLvgtMEJyKZu4OsWeZQ8LEtciPVYyyWEobLnNbJ17LXBvpt+ROX
A/iVwRf1DMpvJ16NJmbxQ/noV/a48ZvS32XY9YdNv7BbxkpuEdDzkDkHkg14
bowgt5EbfIysyjoR7eyekl/TgDp3QpvQ3/Uad4gqhX7ejUJJdpDnreoWPOhT
5tFCQgAyq1lLsIX8HKaJPFL/JqTKoO03s6b69t16SA4iSlickDVzm1e+aZbB
qQ6QogQPj9TbSFXZCe+PpSOn3ry4wTcy9vpz3AjArvC+kjJl3eujyCgrp7bp
U6Wv6dkRW3mzn7UbjBijAIR+Ohj9OI48eo943+CRO6Z7TTiAm3lV5TdGBbbU
fEXo8YkxJIRpB2X61qENUM+us0ebnm2sm05Dj/g/VdGK6K8XaTejQG342LFN
v/PZm1sIRFZ1wbW5LbQDklXK3KneszOfItUMap0A25uKT65Tpm/0mr9N/h+D
SqXflz3PWdmKEnLkJRv2ZDzReoEb7CsxQF8IMA5Npq14xRSXfBDOL2LAkJms
rniRefk37zaNl9VGHh0q6PrZLf7zdc1EgMABl+XEfsg3z/pfQ2BxoWw4/dv6
TWeef0xZI8pZzZpp1yaXLp5QfwCF1xTFaQMDG7oR74s5O7F4bgOwez//JOHy
U80DUd7xqkshXUE/iij2Lu/5oVZQGhcjOiwD7p5orI2fMlHdgH+AIopJBVFN
8KCWfim+Nu9T7QQPVJgEyKz8tCdElOWta6Md4tZhZ5S8u4yIK1SRmkXLDmG/
/eQHbt9+xaNEiHxym3qufcBIZXIALuO9Idd2EVBlnZz6mZXXMorEpnXZQrm7
e+c9BdjXUA51sNKKs+lmF7ze9qsd3qeIsCopNIPkZ8Y1t/ZLSCx6Q/yubCEm
hGuelrGhWS+eVnLcDkhp4rRvnTw82vg4163Xd8H8m6X0ZxEhhc+bhkwLO/Y3
5a+4DaOpCmGZA+JWixVJRAEI5wALAMJC/lybE3EWZrCredkWqcwOt59xUU6u
QdrBz3VTTs1IJHyylUEdfggxq4naYSfo264OT5oToU+N210K+AuUeLUOiFHC
Aid5GacAhJeRMV+svj/FBkBt1/i2djacyWbMqCg9FegpdfM8URMDJnSNnsPL
QH4dW2a1sJ+rPLLCfg72LkQVbfumY3acrpl7xtLprlqIfCP+kU8dPL+95JvA
Cy9Ja79ZA5cfYyg2M35xxhgJF63IyI/kno39TNqamluoCZ7QmMKQAhC20ym8
OKUjvmbyzr2mxVzly/P9Xa0DA4+j8lPY8YkzJKqFaQdsMuwXiy4ThiUiL7qS
mDytjbV1eOx9auAaa5EXbO1EG6qFa9tObkefIPQVgg3R9bXZ31R0vJHwprHz
lq+eQlOpum368AmtuIAVQDYcVR7i9AI3OFaiv74QYByaTltxiyle+SCQX0SB
TLquuZTRaEbDI1r64VnWvI64xQvWxjJaFxRm0ufClBUkd/lMq74Ak6VWjak0
/CRrhWPD7kuS5WotGgNqlJZoDUZqakhdyI+qMveHNaR9huo31XyP+SpBnrfK
A9cCRPYFhU/ld1e7eqWXIAx/qgbU9aHzcpIrsVa3AVKpdfjh29THqy5s7+Ks
FU2l59Zi4ZqWQw7hT8b5TkspGxKJwuhW2oBHxRP55NQfVT8pOOL/jVUU0xc5
tgug7PFuV52JS9pN/FTp61uOwx8OOFT77ejSErXSQ+x+xcUpmJbInJxfenul
gw39dxH1o2k/fJbIMLCDCkE3IMp/7syZ+omHbzqd5cmeErqMAxL7ST+O4Vfw
A+JJkDMdyCoJwQUg9J0HlpuuouFn22dZ89vj20KsgR52A2X++jsgjAUg6orS
A7+N+D+uNCdCnxo1pZm/5yFhvgp8XzJMJMBt5AIfI+OHq7UP5amrZY2bz73w
WOShICWLJzpYWY/ef/3/tXfmcTrV7/+/x6PCo0k/+uiTkhYRE/X5GmEGmaHM
DI2h7A1Zh4xtrBPVZCckMpZGylJCKCp7KQxZsq8RNSNGxscMBvd85ly/+5z3
Ofd99vuc+75nbK/nwz9mzpzlvVzv63q/r0XexZdSh5Rz+Fq8THtIavdxvFR5
bMgmfsFlna7O8CM8QkcDtyDfeCwsBzdWTH7sXWGbhRkUqpRWbNLpDRvbCxlD
TNOnVJtZ+UuN759fASAGvePJqsdMcoXi7flsa91nT5Gwujpczvp1/W6Fl9ee
NV1e7bNP4eii/4bSS0pThn/DqsMErZU7umFgGa2tbfKltgNAPMYOC1GUL6m6
52WuIfewYKR4HTYm2ZhtrgteMHkTX9cLK8phIa5WJmLKknywMl9sYuCZnL/j
645lb05KE+7UzgmrtvI7PyaJNfhMSpUUftFcfvaWzZ9GV4tfqHT2Y0pXaI05
e6WjSTkFV/eOH5z+D2fkYsrWAtHytfJQNt0sOWzrV9LhTqYP+nhJtnvmvujZ
wTD5lfBr1+z7Vyfpbtzuld1KKUvb5108Om9+txp1lc6fmg/3tImeBGA7UT4p
G4Ic8KbViP4hKk3AZf7XLKN3HuelTSQXerXwUW7ZXV0za3A6r8boSGYxvaRs
Qbxx8ddpqccuk2lCCTEKI2zSEvdz8//8/afBPav1SjbyhXZj0QWLGddP91dK
KsnBRidFIfvqcuKGhs5ThAtuWv4QuwEgmpyfwmzVDDAr0/bsvhEjhFHE3kEt
WoW9RJv+5wqMVPqcY9PDTNycJFuyXACjckQD33sAiMVMKQEKAPE6kZkKVykx
aV+2X27BbI6ru9i/5DAmNfisPs4tdUX9Sr17YJSJyIp8I2vLgVsM6qrQ4qTT
0V5sL2TyN1c/RX/R9yUAxPMm+r3DXVw1YckxvjlMrBvb3WdFkfB1dXDuWde7
Voxqk1l8Qz2tkp26Nv5U2Da/kb313UHSsj7EZWioHKHNvtRiLJjsz7KXDBok
W1IVvazbxef3fvAsr3B6HTZmdfRsrQtev8HkTXxbL6woh4W5WpmJKe/ywdJ8
sYtRAIhrZZwWcZNzw5ok1hBdX8o92GZIy/j45D4RMdXaR4+dl/prpiYGRgqO
cFExMiRhVNKqw3qWiP7GvrhYs6a28lDxGitOLCaVdNitBDVAd3ddZ1KTUFih
wdOfiYJC2pYMD+n3Xnx8y8FvhlZrP7DLzB8UYcjGHy6g3bvwb+zlpL1T4V5v
qhQzrlUDUnboYIR+c7Gv0+i0RmEsOgaXiRVsklBCOqOs2aHxgEG9e8d2bfRC
WM+JySt3H8yzsMFq1QDRdYqQqt11WrZf1UXi4JSu1z5FaJablj9E9XpmVzIf
FZUVbKBD2pAV0sX6o8gPFyNDlT5jc4dmJgeCUrS4SWDC9aw1rerIHLoEQRdR
sVGLmFV/6TWjhQAQdq5nNQDEWhFb6xjKPdFRXHDOfCMiOS314AVfLJGsSf2f
0eq9bC5b/GQNJjX4bD+OiQ7N7qJ+cUmr8s3yciBe7FJgNBaQ0C862otvCxkL
btLYWWzRVw9O/yagtwqJZk7FtrvPgiLh2+qga32YuUiJxwGaD2dvqBlgZl/q
h1Ouq/EfUI4l3S7m9q2oWVMhz43kgEmZD1vrgnXMNDE764UV5bBQVyvjiWBL
PvjjhK/GKDU9t295/RHKEXJyy6gNB4tyZ9Sknq9wLGjZXzf3zPrO3cNKiKuz
4/Gyb61IV6eK0nUxFRdr8R0sPNSOw6Su36ziVoabrsIOhsbB5o9NfV6Q7sYO
sq1oBcYnGjrHAbx3VpyPO1FMDnhb4vX9yTnnsTkf7DU7ONBvLlHxU09G/S07
E4NLt0MNV2SS3IB9XTHtGSAq/xz2aD19QDXZNU+xFKFTeFivfKfvA5x9dNaz
OmulLVmhK3MMPBZsIKr0GluVO7V95k4TDyLpBMRSZLRkrch3sbR4tRcMkmAb
YbWIrVXM5J5z76ZxL0Y+FSQK8uBX6i47YTMtgFKke55qvDfoHRPPavuP05cq
eqKJrMs368sBGSow+v4w5ONCZk8y+3Hs7sXvnUytGx9GiwVFwofVQc/zSnZn
XX8kZjsYbMjom3jaL2W6t8/ZlfWMHV0Z6w6rdD/ZSA54DQCxuC5Yxkwi2Vkv
LCmHhbhamUyEQMgHXzBMTU9c1rHt5xQBTaeG10r51WoeyADARK7+usaWWntn
alzOhaPfb/yqS9+69+q6g+ps7IuHkuLRm4WHiu1pqR+95JJis0ZXXWdOQZoB
cGX+uxXd7qPM8cyCVuCtoI/ye01OP70i+Avpx3F4kCxxu2EIBs3Fvk69chlt
2enUEzdYENkz+RVZfzwwdxGfyyKoTQOpdrkaJjeUqw97tI68laK93ENO/RS+
WR64aQEgkt7r3XiXfFRUOzDOtWmv3qcdyXZkhdbdTsBQ9bKITZVejo34bgtH
G2TFXtBPgm2E5SK2FjGRe9IT8079vmvuisnhEb7ExrLzQY1Lm7dNcgv31H1n
+49jaWpUoShGSoVV+WZ5OeDR1fYNLCDydSETx2ErZToOA8lcGAEgbljb6stq
+91nQZGwvToYWh8kWX96/SLupau2I4y2EM2+1A/RJ4wlHZdm9Qbjjd2dKk78
TaYYG8kBrwEgVtcFy3jVxCyuF5aUw8JcrUwmgh35YDZf7GKUml7L37+lRCWq
MwYXKmb7Knobv7pcyzn5jzKtNpuA/1ZNNOFQ6QG1bah0UrXwUKYQWjrs02i2
17LW90rcJo2NG6tmNLxXmjUXf1/07hyPnz/rNZXodi0Qr1aZ6XZ9FCNfvG6c
Kk7Trq744OUl7pEgfK/yW0xOP70jvLYXOeCrP7lRc7H9BK8O0gx1nCCpFkTu
3IJ+c/ZLNrjpxhq7lTZ9h0UUpgHnPJ7c6eli6ugwHjYSlMKcPVpnS4EtgjL/
WJUBYilCp/DQzduji64VLHhaBj0qFrjk9q/vJ55yWpYVZOBux3xFJOXB7Sdv
/9N8CnBmBSV1F1wVbFQbpOyQ8G4v2AsA0Vi1fmI0kfPPnzyfp3wAUwxaeUko
p4ZtPqtWYTaXxanBZS8ZPGu/ja02zX44l5X2xvhfs315nIG7SNakfk+7nfbd
HuDW5ZvV5YBHX4U+sDrxQUelIULuelmQoM8Lmcmbi8FrN7K3jhixj8//abJI
ecesdwTMCmfbHi1WFAl7q4Nu1PnFNVPXnc7zvKHOdGb9oslhy/wY2fWulWVq
v/WZBd6+lKm4tucF6UZD6weA7BkdpviJof6jEf7c4Y1vfLzkCmd3XbD8CV41
MYvrhSXlsBBXK7OJYEc+BLDQvH5qer0LM8c0eHGJ2qW8UDHfVxEaQb+bnHtW
DV4jqGqsgrAq0QQrtVZH6QvB9ExV+7NooLC632UWWH6oMH4MIkade1Z3/nyN
2GuaY6yrX098Klny5RMjv0RdkUtf8MIQmZufICtU4sudF1rEKM8ef2l+Ztpg
0T9c/hqqOAs2X5R38GvsseT25vqtqETZdPEybi42isQoPAkh45/O0FLkDJG9
j7gZeD1reUQVzxaB+caaQf5AntzMFSNmZJgKQYVpIGSmeioqfP5htWMNS10Y
OUGRyFF3eJAY9hgUO2u1W49TGSDnxvUoVsmscnqhIuq91gNAVFYwyxEkxt1z
p4e9kLBO1MMtyQoB3aAzhQNwwdXNravOtFkNxJ5Kr/lrFq+qToqiQaxXaH5W
Yr0CiMVSuVLAUWACQAwmsnPTovgHNC3AC6h7nkqx6Ryiu3sjJDAXl3LVTo4F
1LvEf+8ZW0PMVWj7cbphZUo/livzh1X9RNQqrco3i8uBcKmug7fCkz9j64B6
UoILXxcykzcXIy6PrusQJjzFZJGygFnvuN/QaMWx233WFAnrq4Nzz9puDTru
UvkeZx+d8fyzopzUfUMXp3eMfSIoqE3X/bmKHzOLQLRKrvw5L8LXgWoNnSVV
b3mSD2ke42GjdlAsyNvV6am+QvIxu+uCJUw1MZvrhSXlsPBWK7OJYF0+mM8X
mxgFgKhf4cTWt5+XzdmiwMz1hcTtXJ0dRSFQq8mPZ/kfC5m3izcenqKo/uPM
2fJ6mf98pKwExwKfFcoPlz13dJ2SDw/f6MkUYeWhLns58j6d3nHu3zwiurkn
goyZnG7rNefPL6PqLjqp+K04azjn4f61xsqrHApzSjGFb1z8pXOj+ccUwiF7
+pBHimuSV/ApppOqp6SJRRjlryHL8StcKYw0+Zhkp/C+jj3B2vVi2ovuQ3Zd
vIybi237yy0mLmPPxIr6O+2aEGwu54uJEfeKSzkfJRcrK5Vi7jTOCr5rnZZz
z6xuUX3gRi+l01QGyPywmiu0DcLb1yVKdE5UZ03h90CeUXlS5e9cmVg6KHLk
dHm5Va2ZU1k3zi7zwGexMdW6dtv2TyFKADFKwtcAEJb5XFxYlSPZyrRl6Pob
uNbQf0uql0cpsoOo0vta4U5Mzh9UIv6z1UbFfF3fkhzaJOxeb6eTgQ4AEXOY
BCoARH8iCwt3lfL9l/4kPwPhTm1LqfDI5F02vYKZEJMPM2furs7NXBJBlKhy
7doSypNiLv/UiLp1l0iJTG0+Tj8ARNDZRKVCqQdal2+WlgMycPBmm1GSBZQ9
PbFKmqQu+rqQGb+5KIE9SqnJIuUd094hb07FdkeLNUXC4uogNEix0PiosfPT
fjsrOnLknz66NOaRiu4qhGyHv4FShXPmbGvfsFiUNkO70BqSOu1cm1rrQ0kR
Mv5ScTTanhfCPXj3J8Wiz/ZJFNoLP2bqKXaJjYeNykvBmb6obveUU8JX2l0X
LGGqidldL6woh4W2WnmZCFblgz9O+CqMA0AUr5B5YOZ/Sr401Uvt5gDjLbGG
4JfSoeSr7gKFxF06v/eDd8ITh4plW11cPPn5yw2Xn5bNQb50QlL1d6arqt6z
bYGYzjUiZrD9YS53ZVqrhzUFpq08lC/IUqdkb3FSCA+9eGja+Ki3BqaflT2V
yY2WwoaDM3ffwIZ9V8uexUuDp+5J5iepa4rFyAcASV5k7sAuZ+6hYTE9fzig
ygEuKKglX3JXiiHu2rEDK94Ib+8urat4DS5n3jtVlDVYr3495aXiUjq4/LxT
k96tf6/lrVENLnswsrhpCizhu3j/ELtuFSbNVXDt8MB4dxnK/JO7P27YoqHR
Tjvv7hJUZyJLjcjlbV/Z942Jg8sHhU91yTRZTSIBr07jzk2L2pWR1aLKv5a1
euXbEQ0/2/2nThI2JcqzCS77s2EN02TKJ5efs3XTx/UqRI758HiO9l6s1NEj
YzefzhcuvvD90n6PlWw3fb5q2Muf4pKNESX11DlJIw3Upoc+V7K+a8R78pR+
K8X8bMhoB0aQ28JKxzlPjY7puUG23FuZtmQoc5xr5zQp6Rq3/+OX9R6N0g6a
BHjrwe94hDl8GNWKm+QeGvlO4/uLNx7Sa/mu3Tme+Zufs3v38l4J4cNGHLrg
mgX3R8/Rr5TNrs6ZN6Z2MdOkvsyvyaIPpHvC+mxbqTCYyM5NC2oljcuQF4s4
fWRJs+pJazRCzwJ5a+e1eUhyRMy7uLN/w77Lt8ypHvRvXimSVXq1/tarUiNK
sCZ1LRypDd9VrC+2HqcvVfhOCWo856cCVw9+OarRZ7LqhNblm5XlwGgbma04
bLU6vX14c1l1Qp8XMs2bT3m1+fdr54mbVE5PGTvzRcor5r3j1anYVvdZVSSs
rA7Xzm9sWT1p+Y/ZTi53zfwupVgxdD7TXaUeiorqQunb+/us3M8ewWWf+SWh
bek3OvySqSNusqcPLllFmK05p79o2WKjTKEN+LzgEXbJ/jX4Q6Zh5h/8aUDd
lp8M71gi1KO9qMcMmQ4b3oWMzQWXarp/2qvSpq4P64IVTN7Eh/XCinJYaKuV
+UTwSz74BHcq/f1y/MKoOgZ1/z7v1Ilfp8xOeEQnr3Khw59alqwzWql4q3Be
Pj7z4671IvoMHZAUFR4+oNeiXw+oAnW5sye+T0wIa98sMbFHjxYJ4bHNUtf9
lK3WcCS/zV0XDo3qF/lmEn+3Qf2/+/28zli18FC6nLVjxDt1X45KGmB8DdtY
bhbWNmlAl5hmUzYfVAuovT+NrhvaeWB09MS0TG3qj7zsvWNSYmu5XiMpum2b
xfv1dVrZ5yd3rRc+YPr4LRnqSDbxNRI7RgxQHhWRcPo2f7rwsfxT5n02pWUJ
33MBmRggN1Z/2ryaVO7cnUe0UUidEalmA0CGWXO5RNw7PcPat+odGxmZkrJj
73p+k8pgp925f8tHTVyd0r9vk6i35i05d53LXb90cM0aXfpEvqnYf+Yyx/Qo
+UqMfEdCS+6WtVP4u4ljb/LypXpJ7XTQBKE7z634cujLkYmD4+NbDuxQK6zn
5JSNx/WySXuuX5zy4nPl64eEhFRrP7y/buppz1N4MfuvEv11nXy4rLRxjR95
JGGW2n7xF5dWM6xjSEhoaNUWtd0Z6lxUKtu4RUhIbNyaM3qfV5C3q+NLJbsl
acdqxuyxNV+KHNQtesQGjV5qZdoayRzX+BnerUarTl1i4j7bZ7nwEndj38DX
dauMh7Ttapalypj804dXD5/UM+z1yHJlazfj71SnffTYOR/+8keWWChZnTlE
RJhf8jdo+lz5ClFNQxoy32niVdzPG8kvaNCgcsWKDQxeVf1prh6sX/45fsJ2
/PInHywCOUYTWZpKrVq1GsDks342dSu4ZsfiOQmuwTAoMbJl68X7eOHpRd56
eWkmYZolNovqPnOBeprYeJyRVOFyf1jY+cUw18rUQ1XlimzIN0vLwe6VXR9S
bteLb3ZgXkyN1/p1jxowTHXk6vtCdjkrfbD05u+P2evSrwxmsdki5RXT3jH6
XtkV1rvPjiLhbXW4kNq71sKtkjzmclfN6/JQUFDNigM+1Qww1yce3T2/XaPw
hC7GSo77qWc2dKof2rVv9JsdN2So2iLQ84Ld9eyJb7q159v/zY4RiYk/Z96Q
aS+D4xtGT9WMGTIbNq65sEB4ye5RvV13kz7Bt3XBAoZv4tt6YUU5LKTVylxM
+ScfbPDPwdkNFIs+U/aUtI4o5VYGg2omTzJ3P7690fXbBBpYehafg5RdtnPX
UgGsp+YjAayhU3hYTsMbmKfkrUx9JbjINxkAAIHmtpBvdyZQJAAAdtFN3H3X
w+WcP5kjM/jFMCV1RL8NMtJTHvG9GFCACGQNncKjSA2QnD+/CisZLQtOBwDc
ntwe8u3OBIoEAMAm2DLSwruVllfkvuZ2r+xWSpFDyTZ8+NK9N6vKtuwddKoM
32oUoQHCnZvU9/7X1clSAAC3H7eJfLsjgSIBALAJ2zIqzADb25AbKz6qdU/x
JhPmnGOud3xWDT0HS1vwkYwRD00pKvl8LeuXzm1L16i7KkORkKTefSW6L9vl
p6d6YVNkBogzfWl8+dDFJwMb3QEAKGRuZ/l2JwJFAgBgk7wzX9UsbZYW5q6E
O/BdvTbJYq4GZ+6hwV3KvKlJ9+rDbdMXPvuqJvdgISHkrgxuGreZhQBy+dlf
f9K29INdFxjmMr11KCoD5GBqrcoTd2K3FIDbjdtZvt2BQJEAAFjnetaaVs3d
mZf4SPxX6847gjhcAT4hRlqnhlFJSUmt60aOWvrNuYBYDT4VM/IRzpkxZ1KT
yKikAa1atRqWEB7aeWzyGp8z5xQtRWGA5Lqe4mMiUwDATeZ2lm93FFAkAADg
doBP6T/wQ98S+d49FLoBkntmdXvXU3D2AQAAAAAA7nQ4Z+aXEzbbqkZ691HI
BgiX+cWo1X8UkaMXAAAAAAAA4BaniOuAAAAAAAAAAO5mXKZB0fwDAAAAAAAA
AAAAAAAAAAAAAAAAAAAAKLh4YkHrdhvPuktTEXd4Y2LLZL8KCAIAAAAAAAAK
lWs5mYcPHjxxIsd5s9/ELru/fqN48Qk7PUU78pdMKF48ZMlfN/GdAAAAAAAA
APpwxza9X/O1xmUr8iWFqoV+k2k5W+z1rDVRL7JSRJaIaLb5vzq3ubLko4Yh
jV95svxzjUPk1BmRmmWldkbhGSDXck9+u3pm56R21WtUrFE1NDQkJC5y1OIl
GVfEJnLuWf365IVXNQ0mfFHT8Arl6zdVfFHHL38SS+Bl7phcu1atKhUr1lJc
ENItaR8ObgAAAAAAwN3AiY0DSzkcrXoduWb7T69+NbF2MYfjySdm69X7zs/K
3PPRlLYPOBxN438z0a5zjs0SbKAq76Re+J+dxxeGAZJ38WDq7D5PlAh5s9X8
X378M1e6ef61jMXzEuo1X/OXk8vYM7HiPT1WHTM02M7vnVTe9UFBL3+4OEf/
iwqO9GrMf3PjuC0XUCUEAAAAAADcRdxYMTWsmKPa2AXa/XyvnBvXs7TD3L7g
Tie3DWppat1kpKeUdd2lmJlKr0ugDRDn/i0f1gwt1jA8Lf1AXoHOBfk7l7/W
IGVKo8igCk9+fszwkIbbt7L7/Q5H6TJT9lzRvyI/Z12jcvy5k0/NDgAAAAAA
wO2LYETYV/5d5Of+1KQKf3Lx/pwcPXWdcWPF5LJDUy+ZXcBbQI6KlReeNL5I
l0AaIFzuyjlvPOCo1K3btrPGxhLnPJwYF2zsVMa4Mn/Uc0GmXm3iEYlPzQ4A
AAAAAMDtS8HVLc2r+aL8k1UtumDDzJAPv71heAV3OrldsJdjFAMCZoCI1kdw
XOvt2V4MAna6UbrfuHNGByDcjd0dwl0fFNwl+fQNg0vSF7Uq7nA8aXaMAgAA
AAAAwB0IMyJ8UP5dlsWm+bH3edeiCzZ83OCLXYZq/fVzK8JK++iMFCADxJm+
rGsp14dUmLb3kver+RYLarvI+Iuu/Lnged6iCp9maHZZcF0DAAAAAADgDoRt
xfsVAKJxRnIeXLkyw+PFdHVBu3absw3v4o8zUkAMkKwD0yoF8wHj076x1Ag5
x2ZVNg7ucAeABJcc/vNZ/SvYqZM31zUAAAAAAADuPHLS3q0c5JPyL2nRGmek
gt+HRqRZ9iwSj1F88wHz3wDhnMeTOz8T5HCER67LstYGOcemh1kIADH5IjHr
FwJAAAAAAADAzYe78Oe6gQPCm0Yl9e4Q+faIQ/91ntuwcN3J8x5NlcvPmD0q
skXfrvXqjtl4gK8ucTlrx6iU6Ohmib2GtHqh5vgfDziN9Nr8a6fmftK3fnjC
kEGtX27+5cELfLSCXwEgGmek7KPTGnXYbdmzyC9nJL8NEO7ohoFl+Gy4YZOW
WD0Dys1c8+VPuYbpgqX8usZfJB6RIAAEAAAAAADcbJx7Nrxb8cF2c1cz/da5
dkbjGl1fuc9R7m1PFilu94p6PcdlOulS6uB7Hq28YOe+mXExn/32Z76gP1+Z
P+qJ4vpVOSj3zJrXGz3YOXHff4VLs49+3CC+7aPBvin/Yhi1KtNs3sVdiW3L
vGfZs8haHi1D/DZAsib1548/Hi83fZ+hS5U9LIS0iEckpnm0AAAAAAAAKGy4
w5uSHwuqLC/GJ4Yzy3x1uBv7Eiq+u5UPqRDODoL+ExP26UFP6HTBhk8b3aMX
In0ta2NcZJDC0UhMP+VXAEi5UhGvsUre9eo9G139HpueRX5mo/XTAJGMhUAG
g//x89sP8QdDNZoI9dN1aB1RKljPdQ0AAAAAAIAi5FrWd5FVHKGhi0/KilCw
cnVyX53ze8a/EPXTBXcIRlDcpz/KHa6EmhpaA4Q7N6l/pWIlui/bJb/4UuqQ
cr4p/7oBIPnXspZ/3ulfNjyL/M1G66cBIhZAVBww+Yn3mia5J+dWDdZxXQMA
AAAAAKAIyZ4+tHKQo4r8+IP0cuSe3TdixJLs/0m/UodOC2XHg+4fma7IOiVG
OqguZuUqfFP+jbRobwHaKvzNRuufASKaPw5H409/CpD9UfB7UnPzmibei6QD
AAAAAABQ2FzP+i6ikiO45OANp+U/ZhmidF2kmPKsNliYT5GmADeLdFBfzIwI
3wJAjLTojM0dmln2LDLMo2UZ/wwQwV3N9fx7Bm/82+iarNRhdWR+UzyVyjZu
UW3A9wd0zi8sBIAIaccQAAIAAAAAAG4moj6vNhxYjIa+i5RwdqD+FTvpUOvz
olasuVh4qG/R36IWXU9wBpPf89T2mTv/tBkA4oczUmBOQMwMEDeitVK69Pgd
Fw0vEn26jL3apCLpCAABAAAAAAA3ETFwoFWvI7L4D9Fw0I0mYMmjNN5Tgh+X
Rvtlen65cp8cUVysa8JYIkBatH4eLVv4GQNiJwTeqOqiHO8BIGJWAQSAAAAA
AACAm4kQDK7x2xG204Pb9zriUs9vZG8dMWJfjvQrbWwISX5cL4Z//zd/l6tr
Zg1OFw4jTmwcWEqjOTP3J9GE4bKXDJ6133hjX4UUANJ83lZ/QicC4IzkpwFS
kLer4yuW8oC5a5er3NgUiFnFEAACAAAAAABucdjOuSoU+upXE2sXc4RP+/YG
R9zRdR3CBEtEgMWGqLynRJcqpiEXXN3cuupMVg2EWSuq45UzO8c+KqnKN7LX
vlplpm7pED0Co0UH5BjF/0KEu1d2c1lnoTVX/GVmS0n1Ck3PSqxXANG4rgEA
AAAAAFCUMP2W2RriTzL2TKwY7A5PuDJ/WNVPPOl2db2nLqUO+XeQGMauMFhc
9kXjKopteWfurs7Ngt3Kf8bWAfU81o1XRC06NGLtP358c0Cy0fptgLiaKmvm
e/XvdVTqLtVn1HnVM6vbvBlRJthLyfiABoBwmQc+i42p1rXbtn/gqwUAAAAA
AAJNwbXDA+NLthatgPyTu6e82vz7tfNaFRcMEOeZZTH1PFv0BrEhzrVzmpQs
98mR/5EzZ1uPRmmy6oR5a+e1eUgqj553cWf/hn2Xb5lTPejffP0LLnNcvXor
9HI66eLM2fJ6GJ8MSnWkYhPn2rRX77MaAG5IAAwQF1zu+q8HP1W8eNOIad9/
e/KS7G5/n/p1yrSOEXFfHsq5MH3Q/a1NzDQuZ96Y2sV0Ym08ZB+d9SzvoiW3
NA1uJpoqjmB1RmUAAAAAAAACw+Ws9ME9w9q36h0bGfn+mL3/XCcuP2P22Jov
RQ7qFj1iwwFPAcG8v1fULVlndFqWSs915u4b3q1Gq05dYuI+26eoDkKc89zi
OQn1IvoMSoxs2Xrxvj/zOXLu/Wl03dDOA6OjJ6ZlXicvcDf2DXxdt7B3SNuu
2y95+3OJG6s/bV5N/sdNwyuUr980JCQx+fBVqzfxEBgDRCDvvwfT5o5p0rnp
00+WrScUMW8Y1nPCwKXbduU4hQucuUd2nXBqDAftFz1XvkJU05CGHy+5wi7O
Pvp5I/kFDRpUrlixgXm7cVlp4xo/8kjCrPmZflh5AAAAAAAAgEASQAMEAAAA
AAAAAMyBAQIAAAAAAAAoMmCAAAAAAAAAAIoMGCAAAAAAAACAIgMGCAAAAAAA
AKDIgAECAAAAAAAAKDJggAAAAAAAAACKjPNH5rRst/GspyAjd3hjYsvkw5dN
/gYAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgNsGh+Mm/wMAAAAAAADcPdxc
EwAGCADgDubKko8ahsQ2LR8a7BD4v+oLj+XpXfZxC/c1LsqViujWdfulon/f
gMBlzpnQO7Z7TLV69Z6tW+bt1EsFN/uNTMjcMeYxT8N7p2LlhSdv3e/h9v84
uvXgN0NDQkKali8fue6fm/1ChczVNV8k8SMtNLRq47Kteh25drNf6PaAy9v5
Y2rz8PCEpKToiM6zFmRabzfOeXhYx5CQ1hGlxFkTHFq+aWyIjKbPla/QtFv0
+EUL/sjlfL2PS3Q0ePCZ8rEJzSYvX5pxxfg+2hvfvCnA7fimx/Myac8TVKNJ
1dDQkIYfL7HzEXcLMEAAAKCQKTiSGP3IAxVdC1Klt5KPX9W9hsvbvnroY8Ui
Rn546jZfq/LPn/1j15HVrZu5FuJyt7gBwuCc+7u9wusL0a107b78rMwDaZ+9
9Uiwo1roN5mWeidv49K+T5Z6eWxq5vUAv6wZ13LPHDx98KMPmtzncIRGrL0d
DZCCvMMpA8IfqpCy/oDTW0tzORdO7TuxY1C/ykEOR5EbIDeni/2Fy105p22Z
h4etO+DMv7i5ZWRQUIm+Pxy3K3G49EWtijscTz4x+5BmR+Va7vGPRkfd5wiO
iV77l5cuEe9TuvT4HRfVv7p0fs+sz/o+GvTU682WHztv9Q1v/hTgMlI6l3bw
HzVi69nbW5QXMloTgMvO3DpybMdaYQlDkvtEhMb17zpv+4E8eysIl7dv+7yu
PcKbRiX17tPqhRqd3k9atu+EVpjAAAEA3AUUHOlbY9KiL+IfcDiCS3Rftktf
s+Ju7O5UceJvV/x+2tW9E0fuzfH3Nn4+pWDDp43uKUwD5OzekXPXXA3IAn/9
3IowXmWoNnaByQ2zpw8uWcWaSlNwdUvzasJhVrlPjuQH4hWVmH97zrFZFW9b
AyQjPaWssHls3aA4sXFgqSI3QALbxQEczOZkH531bFBQl+TTN4huCAbIow+/
v/lPu0++sWJqWDGHo2n8b5f1fs05DyfGBbukXfteR0zl2ZX5o55zGY8RzTb/
1+CK0zvGPhEUZMGWUXBTp8Cl1CHlCm/u30GoTADnnjX94rqtP5GVLw3H/DMn
1nduUXmkZRufc2amDomeNP1gtvQHztx9fd98uliJ+M9W5/7P7OkAAHAnwhsg
Mw5fZ4uyIzR08UndxVS4zP8163rWsqiGhb7yentKYRsg3L4VtQYG6Oai0lus
x6pjJpoYt++b6OetarnOvT+NqV+9/YdphbE97uXbb2sDhMvPmD2+ZY3wMRu9
n4CI3BQDJKBdHMjBbIpzbdqr9zkaf/qT+Kj8vMzzOfbtnoLfk5q7RFmV9+fk
GLyzaKF4UcILjvRqzJ8V9Bt3zviq7OlDKwc5KiWNy3RafkEYILcDChMg6+Dk
Wg3XntMMxmtZ30XeHz3nRyvSwLl2xouj52crDQ3B6A52BJfo+NVW+QiCAQIA
uAtglkUBZR2YVok3QaoM/VBvwQ2QAXJ+z4SQwl95vT2lsA2QGysmlx0amJuL
ypLX+I4TaxvGm2lKRYaXb7+tDRAfuEkGSAAJ4GA2h+nGHgPEN8QTQzODnU1/
R/D9I9Ozvd0nqPm8rWbvc37vpPI2w69ggNwOyE2A7OmDHjCYAjdWTCkTaXDW
Joe7sbtDuMvQaDl9scIGYT93qA/sYIAAAO4CPJbF1a8/irjXtS6X7Ltau3YH
xgBxrk1r8K9CX3m9PqVwDRDexyP23uSA3Jw7ndwuWLM86XBibZMUMx+tIsLr
t8MAub0I5GD2QmAMkD9+fvshh6N0mSl7DP2rzo3rWdpr0gYL9+GxYO+ogQFy
OyAzAfizMNEzUEPBhrSaZSx0pdsrUu3RJx60qcYDDBAAwF2AzLJw5mxr/wrv
Hd00brM6sDIQBsiN7LWNqxT6ymvhKYVqgHBHNwwsE6CbSwEgWn+Sq+s/WpXh
+VHBho8bfLHr5tsfXr8dBshtRSAHszcCYoCIJ4YmgRt5f6+oW4mfU++kXvif
wTXu+9SL+umC6fPyc9Y14jX68Gnf3rA4/WCA3A7ITADudHLboEeF3AiaLj43
rse9fS0dPTv3/zK1U4e07ccVN5EMk+D4pN9l3pIwQAAAdwEKy4I7kZ5S3mWC
BEVOUHmr+m2A5F3cldjpmaBCXnmtPaXwDJD8k7+l/odXbwJzc6MAkIKrm9+o
v1ye8yr/Ss61m2x/WPp2GCC3DwEezN4IhAEiBoAYBm5wzoxx/SsHOYJjYn48
a/Icb/dxIxkgNpoIBsjtgNwEYNFJjnIPdp6eelwWlsRl7JlYpdy4bX7kE2Mu
fI6guE8VgSQwQAAAdwEqy4LLnjuq/r0Ox+OPjNsul6smBgifWnBRrwF8asEB
A5Ki4kL7dFv8qzw/IXc+baRQeiO6+j1CJZHX3En1n/9op9INm3Oe/Xb5hOjQ
uMSW8S0HdqgVNuCTGccthaLaeIrcAMndsnZSi6juScl9ImKqvdEsdfNB3YjC
/D/2L+/ROaJzy/h4IQdjcv9VhzPy5Vde/2djfGyIVFpFUTugrY+VUwo2zY+9
T8cPhDu6rn1dxY6ZVfLOrO8zPCGsTkhIXGS5J1VKSO6WNdPaN2s9ImnGrDnT
eiW1Hjti8+ZvYmKG6foeKLD+7TLtizt74vs+3aO69+4d27XRC2ED5hoUffB9
SPCVF8bHdY+p9sorT4cVf4499PcVCc11Hno5a8eIIdFtu/RowafH7DJx/KFL
nPJWG8e07Nf6eeO6Hnn/PZj2+fuNhPeMT4qOjktdn56boTZAFPd5MmJtVn72
j2s/bhERk+iaO+2rNY0ctXiJYXWJ/LyMr5dPjgsPT3A9YlhCeGji1PFbMpQv
atDFNpqCAjmYuezMLRM+7ls/PGFIjx4tekbXjpqgKp9RcHVbQkP3sypGVGzU
SHjQoHHeB54K88ANLj9z1gctgoNq9u6Vfs7UIJROHr2fa7Dx7JsBkuU8t2LR
O6+6hI+rZd5qUkvZ9Zk7JtdqUbuErADTME+DXP3yg1r3SPV/Ip6dusM4mEWJ
jwbI5axfJ3zYs3ZYwhDXaHkztFUzfmxLO1SBm2Vc5pwP+0S4htprjcs+eo/g
+Jf7y3djYnXks/Po7vnx0dHuWfPtj7l651ne5bYBChNA8g3gjypeCU9L51c3
LvPAZ9GhyXrHIpbhcuaNqV3MUalH0mGlhy0MEADAXYDGsuAze1ThJW3z+N05
xpcxOGfm9JQnXopaKpPq+aePLG3yRMQETQYethtssvXHpyWML/lK9Hd/SMtS
Xva2jq8Wi7KT6NLrUzwGyLQjX/XrsGyruHIJ+TmDHn14+EZ16QHnnh86vjfF
UwOFy8/+Oq19KZ30iSQt8QHZNBad1eX+JPnXLqRv/7zRsw9NsezyIYfLzzmZ
cXLlN0MeC1YqIVzOF2Oe7JlySt7MuWeWN6hia/fe+7dL2tfqPRs6DRrvtiOE
PcagyNFpWaoh5ueQ4CsvnDowc8YbDwhD4uAvCQl6D80+Mrtzn/Sz4g2Z35Fa
KxCKOOwZ9Q5vnmvaxKWNpNUuXa3/0F3/SIPeNUiWz2oRPbDN/crrr+VkHs44
tmBOF9cofeE/46a1SVr2Y7aUAcd5ZMdHLzxUvHncGu3X5Z5Z83rVCm+POZTt
ecTF9SsGPFt5tDwrl1EXW2wKZfv7OZide9a/82yFQd94PtBlph0aPfiJuNYb
M9QfGIATEHZiqDXYcy4cW/H9tMh6ZZs1nrr2p2yvGatYAIh5lLr8ibZem02B
F/7z3rjmw9fs8mzUXM7a1qNt6ZaKluFOpb9fTv9NXF0Wff/Dw37YZasUhQ8G
iGtsz/xPyTrve4pA5Z/YMbFisYhR00WzInCzjNVp2tCVP8Uu9/b0Eyvf1ZPP
Z6+s/7TNjMXnpHmQPX1IpWIl4hf8mKcUibbktgq1CZCXvffdIfzc55fG4k36
dA9r23Hj6Uu+Gx/C7Bj6WLGXBiXv+6/6NjBAAAB3ATqWBbd/dW9e8Q2KnbVa
Eum6BgiXNfPdOiVVZyUCf++Z9GSxiDFKfcbcNCi4dnhgx3/fp7nbmZ1jH7WT
6NK6AfJ6aK/Z38gDt7l9K7vf7whWxRsyN90q5ZO+SXfKfri9TZgjuOTgDadV
Nw+YAZKf+1OTKspCzNL5TnDJ4T+f9ePOgt+IXAnJPTm36r2DN/6tutC5dvYT
jQvBAKlWpUVSwi55oRa256yKCw7UkPDy0KffGtRi2Z+y54opa/T0Tz2XKkFD
eyYorvX2bPU8YGladYw49kp6lXe43Su7lXIEq+52LWtjXESxWJ1HXP16yksl
NVaztostNYU6Ltufwcwd3pT8WLGGUxbnqJS9grxdHRsWi1I7QflvgIiBG4+X
7Ti8lRJhnzwmauoPK63ULhfvY6Gyp3hGaWs+il2vl+uDVUKRd71YtUTtokNC
euR6A83CWHSxbYCcPzqnhs7YvvrVBzXvKZGw8oDnp4GbZV7k82sNOr0/XjH3
mSOTKvDHptxWoWMCcM7j7/Z8QTp4crxQadQPW70aMmpuXNw78YOk1sl9G7R4
uHLFxFkLdH38YIAAAO4C9CwLznkqpScfSeGpJqxnpwhbWGp1XfolH7gXpJTz
pqYB87PVqQ7G1indusa6WDZAdNLgsL9VLWTXs76LqKQtBciWcq2TRsAMEMk9
uO0iRXR5/o6vO5a1WvRcH612yn+43N50v8OeERGFYIBoPkp8JaU2ErAhYf5Q
nSKPLDWN5nrSM0B4dfqVYEexTsv263SJUQwIeyVdPZC7sb9bY5fO+fI0j/Yl
GDJ67+Piyp8Lng92hEeuy5LHBJkaINban/wZzCwXhEGmKVZkXBUG7rcBIqaM
M5BILKTlmaCXw+cfyDKdPF7uI0c8o7RgqngwjQERbqjoetZWwa933a/w0uFO
vdtg0l7blWHtGSDG5g+TToq5GbhZ5kU+a20W9mjV9Tbltgq1CXA5K31g+/BR
kw6dzdqb8k50SWaEBEUOSznk2zEIl5+zc/vnjWqUfqPVgl3HVc0LAwQAcBdg
4FuV8+dXYbz0rvRW8vGrupeJy7SRJGe7iIpF3MQ0kMoT69b7FhZly4kurRsg
WrXQ4G+dx/d8MfXTY8q4AyPdLFAGiFEAiGu1nRZhIfO8CVrtlKUGKvdg5ylj
Nh48mOveMeSc5//ItOIyzbBqgGj1H1FLucdzChPAIWH9oSJibkwdZVhrUDAn
HKOcrj4YINoUTMzEMEoJK5YSUCpy5gaI5abweTAztdkwfbRe+Qx/DRALgRti
NHFozRV/GT/EegCIO0mdaUItNaYGiNhu8uxbzJRTad3ZR6Y0Szx81fJDJewZ
IGKZPL2jQPbtcssrcLPMrnw2erQtua1CYQLknlnT7Im4Tz2OW84jO9IaNXkq
iDdCKvVTeq7agq2zj6tTbMEAAQDcBRhGlzs3LYp/wCEVadVcJu1rGSkM4iIi
XyxMTANpKX+xX9e5n6Uo+WJOs1aldbejdSkEA8QDl59z7Mi25ZvWpH4tvFUh
GiA6ASDsFfYtrz9CoZNzJ7eM2nDQxjacnnYqOCQHeyJeO0Ykp2oCnL0RSAMk
gEOiMA0Q0VgwGjM+GSDiX7ktDvZfQ6VRfFtFs99sA0RUdI0CiMTdcsXj/DVA
mCVoHrghnSqalRe0ch8B0Vh4/JHJuy7aeE/zLFiqrhe4Mn/Uc0GOSkM+dHu0
Xv3qnfpL9U7cvGHJAMnc1mPSkiuc6PLkKP1gr4/fGzdOPgHHjXtvwfBKSp+9
W88A8WBBbqvwmAB8BHq9+wdp6vPm552a/VFbYYns+4M6bNA6rHMdT1aYtteT
3AEGCADgLsA4vZW0Be0IDV188rr6Min9ixcDRO3nY7DyerubDQrHAHEe3b04
ISmiSo3BM8b98Fv66exrhXsCIuWH1yYC5bKObVfk8OFODa+V8qsdFchAO+Wy
Tv04YnKv2i09uXeqVEhZbyPNSyANkAAOicI0QESNrjAMEOnFdKaS3tsqnnKT
DRC9V9K+hrKF/TRALAVuWEhaZTUARHS9sxOLJH8H8wGj6oh/Dk57Otij7d/I
Xt2mydpzvui8VgwQbt/yl4UcF94GnpJb0gCxLrdVuE0A7sDqXmWM6lFyuUun
NrnPL2kvWnnKo14YIACAuwDTAh9ZB6ZV4k2QSkkLvu+mvEzaoPZigMjXce3y
kXfmh9Fz+OXb23mKDUyeono3iwuclL0zcoQnDwzZccHi9q8dst7OCQUZBoDo
8PdvKVE2nTG02ml+XuZ5madC/rV/duxdM3xki2Bv/ipKvH+7dS0lgEPiNj8B
EVUUbwaIwlYtNAPE4mAWz++8GCAKJzo/DRD2RC+BGyy9ldkJiBQAEu8lzTXL
FeAIC19x2qb/jf0TEFUsBndg1ctjdPwSrWDFALmxYkLIJ0IveDl6U3KrGSA2
5bYKtwlwZf7I+ysab2exddBbqkDnng0jqj74YOvWP/6teapociq+FwYIAOAu
wEuFwatffxRxL3/KXLtB5VkK8W7mok/SybIiSlG7fOQcnRrFpK647gcgdtvs
KSK2Fri8lTOa6IVCyxcyLuv39SfF4vHaBa5gw4wan9hTq0TvDiO3f9mFmWMa
vLjEpjOGThD62obx2pprbH/PsqeTlW+3oaUEbkgUagwI02kLIwbE7X1n4opP
7sMyZaRwoRkgFgezGG1hVJGcuTkp0wj4ZYBIKePMAzfEpGQm6QssVjZnGaof
f/j9zX/atgOsxIBoHS93ft2hpMMR3Wr7JR/DzxkWDJCC35Mq9t4gDAMWfKQz
QfS4xQwQu3JbhVUDhP+KRqxkiTGiKNMpKUseA0S+gQADBABwF+CtxLm7BpPW
Y4flC9UmKSIpZ3uQMk8j0zoMTAOWU8tIY7n61duNVliLODZ9ivjN1hc4McJX
Z5VkO65sIZNrZczy8tMAMQoAUcGd2Pr28w1tO2PoGCAbej+pTKPE4Fd2GwaI
92+3o6UEbEgUqgEiZcHSj4j3wQBhmUIVqZBcZuZbzwTpJSMiyTxRHVQFyADx
fTCztAYGqj4zT1TOS34ZIOzE0Dxw4/SOsU8E89nFp39jmD1VvI9pWl2+Nk3H
f9+nDhy2ipkBwmWkdFZlwRIRQ9FLDl7x82Sfws8Z3g0QPoO6JyM3M9n0d5lc
A7VLo+W3ZhC6fbmtwuOCdXTDgIeM0/Zez1oRfn8fbzEgOWnvupqx4us69X3E
3YZgxVoJAwQAcOfjEtSdKk78zWw/jTuRnlI+WGdl4ZwZ4/pVKqYnnPm1Pqjy
4HGKamNsP022V6yMp+ayZr5X7z6dygiUc/qLVm1++cfaYu/lKTw2FjgpFkO9
I+rSB5pHPnePzkImps2UuYKcG19/wBarpYrlD9UGgMhhBcJemqrRVbxikIZX
L9nmnolPlZu+z+p2q/dvt6elBGhIFKoBQuJoD9JJFyylszYyQBzF3lyyU5Vk
jCV/qNQ9UVGejG25h2uNRC7ni4kN7ivZZ9V+RRMFyADxZzDn71yZWFovQxS/
p/FyUB2185I/BoiYMs44cEOYLJX4vKkjp2cae8t4v8/ZE8vjYkrUCk3b/af1
7HAKWBc8WXrgGo3FKgykZ1RdLyGGor9UYdAa30OevRgggm312L3y+pVZG+Mi
g2qELj6pbjVn+qKYsfOz3Z17Sxkg9uW2Co8JwFcjii/5qk4JHtdwyJ6b8kQ3
lijSc/3x8ckv/yfiw/QTnj84f2RWbHOd6qLS/p6qIKPDcWJpy6bVeiZsy/K7
nC0AANyKcHnbVw99rFjESIWXrPay7LmjwkrorVnOy8fHvV21TLWZuzzLsZBv
v2Sdd8cdz1ErS6771L9XqjfhUs9GNxkvTyDDe+2Ojy2tKO/rWvGXtm6Yutc8
db+dp7g3nTQ5QkVne6X6IaaHkjt7u756SuLMn3+d+Wywo3HclgvOU++97HGK
uHFxc8vIoApSVpOc0wvbddt9iawjlj82VMa4vFMnfp0yO+GRYBu1MOQwv2W5
f5dggNR/I2r6NllGeuflw4PbPzFapmN4xeu3sx1mrWuZGFKkOUcIyJCw/VBx
+1TrhyOOEM3Ice7dNLpq6bazPNWZ+UEysUPPjz/pyZeHrjFja/qpv07kuDf8
mcpU+sE3B7ccs+mg1ObifAztnaRVQV1fvSymTsnOvRTF1r9Oa1vm4bdXagqi
abvYt6bwbzDnblo5pHzJ+E+/ueCphH5xV2J8yVeilh1Tu76wremwSUtsG9Rc
/qlhnYxCTrhL5/dMFyZLlQpDl/1oVjnOnXZDmz2Yy889sG/N0LGtypZuO37M
3n9M40PMcXV9pRLdl+zdMaxNqkJs7vmsQbXSPXS6XoQddekYodZhJyx6ZoJQ
lmJh8za8vazyJ8w9s6H9ayVfif7uD09OvNxNyzq+2mefPEle4GaZLfls9Gjb
cluJ4gzCZZcNfPPh6Oh56bvcUzj/79Nbh/UJ7aOpY86O4DXhSM4jv06Nifxg
5bcnL0mDR6yuHtRgsPomDoeQGst6oj8AALh9uLLk4xblQ6W8q0Lm1W5dtxup
FteyNraut0DXy92lNe3bvqBjlxoREX2GJveJqFGje4eF2w/k6V/rPLdk/uDa
lSK6du7bJHrEBq0PA3+3Rb2GvFYjLGHIgKToiOajR+w4ZzPM0/Ap3OlxvUKr
tnBneaoYUbFRbMPlp7grSz5qGNI6opTYHkLx8ec/2inu9OafPrKqf3Lr56u1
798yvmX3qN69vv+dV5+c+7dMjYkNaRE1dfNBxYdczkofNqxd1ZD4oUnRb3bc
kGHt/f85OLtBqPr1GoUo8byka3mqmTzJXgaezB2Ta8c2dfd7pbKN2/CfTxlb
BsQkH798+fjMaR0aRiUN6NGjRUJ4bLPU9em2S/0afDu345sez7/WuGxFh/vR
LULe+mY3l618Jdc4fC2k4cdLZAax70PC9kOv/7msySuvPN2AZfh3BBcPax4S
MmicS5FQjRC+a4aOkysYXHbm1pFjO9ZyvWS8OEiO/JN/fMOAB4WbhITEvtVx
Y6YmZ+lhl3725cAm0UkDBiRFtavevlnqup+yjfo0Py9jyeKRjWrU6NQssdfg
jjVrdPlgxFZVqmSDLva9/X0bzIpmGd+pZo1Og3v3ju1UIyJy1OIlinLkBVe3
JTSu92x0danGtDDsPbPPhKzUYXVClB/bQj5ZXF35Qqn/q9iyd6tJSxcczTa0
GtT3ERpBRtPnyldo2i167LzUXzN9KzsnI+/MmuHj+O3u/Gun5s5KiGZdHxfa
PX72RuOu5+FOJzcrM8G+gSZOBNkHiiJOV6roHTG4Bt7XyyfHtaveziUcBneI
bDhy6TduWztws8yufL5i+Gj21nbltgyNExSXu+OXz7r2b/282GSxiR3m/7JV
p7+cuXsHv/XII5VGafMH5v33YNrcMU3a1wlxyflXHn64Qqe3u8qNGtnTD8yp
X7Xsa610Dk0AAAAAAHzDa+UCAFRwzsNJ9acftH/iCexzc6MwEAMCAAAAgMAD
AwTY5Z/9o5sPM0syDAIHDBAAAAAA3GnAAAHecJ7Yuf4vj8fXhdSOjb7zPfwc
2AIGCAAAAADuNGCAAHP4dLjBjhfDv/9bsDnyzix9w14uC+APMEAAAAAAcKch
5u0pPX7HRe8Xg7sQPudVsdC+Q4Vw9bzjKU1S0s/i+KPIgAECAAAAgDsG87w9
ALhx7v0x5VU+R1aXmLiZ24/7UvQQ+AoMEAAAAAAAAECRAQMEAAAAAAAAUGS4
TICb+w8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQeFxZ
Qg1DqHFZcjjEfzWaUGgohYSI/+qWoQYdKDmVtmQQd7Pf1n+urqGkWIqpRqFV
qWwrOnLtZr/QTecsfd6REsL4vo4sR58c8ekmHB0ext8hopQ4ioJDqWmsZxS5
/j1Xnpp2o/GL6I9c4/tk0+eNqN6zVP0e/dHYtDw92IDaD6NFv1JegY9ffEfC
7afRrelNoa3Kl6d1/9zsFwogebS+D/WJEAfAwA2F/sA7uTHvYPLp1FzqW58S
hlB8Q5q6mZx3wIp1ZxDYrilygXCn4lKHereg1s/7pw456dinNPxV6p5ErVrx
/VLtDZq8nM5eD/DbgjuWAtreRlD5tIOQo5ydtKAVhZSgtz6nc7f5oOJy6NQ+
2jGIKgfpfGzeRur7JL08ljJv88+0QT79c5SOfkW9SpPDZwNEgkunVsXJ8STN
PqT53TU6/hFF3UfBMbT2Ly/3OZ1Mwa7RGE3bL2luc4zW9aN691GTUXQ8x6+3
vaO4RmcO0sGPqMl95AiltXeSzuwSQSfpxFoa/TQvowZvLPwn3rmNeceKOCft
60slX+FlC3eCUsqT40X6/u+b/VaACqFril4guDlPXzamUk1pjbclLFAU6oQ1
V4cskUvf96AF+yhfZlHm76TE0lSpO+37b+DeFdzRHOllYIAwOMqcS20foMiR
lHkHnBqcoIGlNB9bQFuaC43gtx5++5FP6xoF4MNvrKCwYuRoSr9d1vs1R4cT
ecsiuD0duWJ8F6kjqo2lqwYbZTlfUMS9d8potMVZGjnXsFkoh2ZVvNN0ZjdM
RgVS37jbGjOwIs689YoW51p69T5qu4g/pmdablAT2nz+Zr+WFQpo70TaW+R7
KVfX0Mi9RfEg37vGW8sEXiB448p8ei6If2jjT6koTuCLRifRVYeskT2dnuxP
O88pf8rR7g5CK82kG7eGfAC3OF4MEOIHVcY43lKOnEDZ/yvSdws8BjPOuZfG
1Kf2H95x24NeCZAB8nsSb19UeZ9yDKSzaKGYP4gpfg7qscrY6+8GrW1MjmBK
WHkneAZah9tHtQbSJaPF787TmWUEXN+4CxszgCLOS+sVJcLORtC/PVKFy6HM
vJv6Sta5TsuibsIYOzeOOq0v/Mf40zXeWqboDRDKpQ1dqHpH2pBRRA8sCp3E
ZwNEso9K96Nz+YrfsK4J7kKnbwTuPcGdi3cDhHgX/VnP8lrf4Nvd69IPk//O
JCAGyHVaEebFcCjYQI3u4YfQyHTD27gUm+73835cnx8zexqzZe42Eef66rJD
7y6d2U3A9Y27uTH9x0vrFSUB2j+5OZynCSFFPsaEPeqkIljH/ekaby1zEwyQ
OxI/1KFzs+nlB6jrl5SnXPJZ12gNEwB0sWSACCdulYMo+HXar+tjc7sAA0RF
QFbwP+jth8hRmqbsMbzk3Dgq7RpmFWnhScNrctIEl1QjPy4J0U6pRt9k+v7K
txnCduK9yXepzhxgfePubkx/8dp6RcntbIA411KDfxX5GBP2EotCdfeja7y2
DAyQwBBwdeiO2akGRYVFA0TU+kx3sG8DYICoCMQKLrpXRdBmo9CzPFpRlx9m
Vd6hC0ZefJL7qIkflwjrRFN75w6DO0oDy1C5t+9SnTmw+sZd3ph+4r31ipLb
1wBhrqRFPsbYRuItbYBYaBkYIIEhsOoQR8eT6eliFP8Z5d7uvvqgqLBogLj9
88On3c7hRTfFAMmnf3bQ0k107hZ0Tg7ECs4CQAxPXaUYouAY+vGs8V1yaW5V
bwEgDNaJd80ClH+SUv/Df+9doTPrTZYA6ht3V2MGGkutV5TcpgZIHu1KpGeC
inaMcZT9Nb3xQFFJTt+6xlrLwAAJDAFVh3K+oJdK0tsrYX0AG1g1QCQ/f63v
PZdNWyaIub57tKDo2jRhOWUYJTu6TL9OoJ61+Yt7x1JoK0pdrx6xuVtoWntq
PYJmzKJpvaj1WNq8mWJibPr859HBNHq/EcUlUnw8RUcLD8rQzDghtbhJOYz8
P2h5D4rozN+kTwTFJdOqw4rUc6o3T21OoW9S4psUHss/8cIheieO5q2lzyKp
5CDKkqnoeftoUS8Kb0pJAygpikL70GJlkQtuP42P42uXvPI0FX+OF8jcWVqR
QFHd+aZr9AINmGuQDCqP9nxIHRrydxYbeR1lO/Wu9H8FlwZG83l66UE4ypxF
LYKpZm9KP6f9texCdsRm4VxDDCextgBlzuHbtk4I34b3J9Ol63RoBiU2pMTB
fKfH9KKF2/ULi1jtdycdn0W942hUKo17j0Z3oPcX0fYxVO9Ljxnl6rXvBlKz
BJo0hz4eSj3b07yfacXrtMDYG03kOm2MF5PeB6tqrLRVZiqW6cyux33fx3iQ
uAZ8Il/qIrQq1Qjm+92lVc5rQx0jqEIUzduvsP6sTG1XC/cWKuzUe5ZKveaZ
WYpU80/qqBPWJ4tH3/gfHZ9JXWIosRf/Ce2H08/W3fAKozE9LUVnv6UJ0YK0
aUkdatGATywni5aJoMZlaeBGyj9Nq/pTxOt8y7R6gbp8QFuNizF5FSNGIs6e
eLHcegGR3t4/KpMm15YqEAVTWHPxZd76xnJuCqHLJsdR9Xb8U7rWowHTac8F
zWX5lPE1f1l4Ai8KEsIpcaq6NpZrCrDiFK7uu0dwTsv9hcbE8vURWHGEVFn9
i/Np4mThax6Vo4jXPNWOPtqpagXLYtzr5xyhlFqegk3yKksNP6YrdnYUC69r
rLeMDwLBeZQWJ1Do6/xrM3n+3e9Wh4p8EYlI8yxztvpdgXlnWZmwLelIHmV/
Sz2jqdfz1CBZk/n2Mu34gAaEU7t+vOh2CdjJq+iCavAYGyC2myubZlah+AXq
kBAAzLFqgDBN1aH2tHHuoXeepUHfyARjHh0aTU/E0UZNvgguk2b+h+q8T6ck
HSb/BE2sSBGjPCudy45+siedkr9MLi1vYM9Odz0orTZV60+73GoPR9nLqUU0
tblfeSshtfjJlTTkMR093PV1Hd/zvC3bRGpfSv+Q8dxsavQgTdolzlMug/+0
oOa0O0c4nRxBNSdTdr54n8zp9MRLtFSm07q0jqVNKGKCLOuFUJXgwExh28ql
Dh2khASPVsOSHEaOVhg1rLm+70nf/uERF2zfskRnvezc/hsgGZRSVsdw4HLo
2AqaFkllm9HUtcbrpoQYAGLixyUhZkS09s755+n3fZTeh99VK9eNJr9Fiw9K
bc7RuS/43mwyTp1pxGq/O2n7G/TGUsUqw3Khe7I1nqaR1ekrua0hHAlVuNdG
m19KpXLWNu1X76FOg0wHiTyXfjmavZlGtKPDl8QKLPLtBYtTm7Xwz52EGB/Z
zBJTzb9H9e/V2c+0MVnc+sYPtL4XLT0qDWzB3zjI/FitsBtT/IVY7+A796TL
o20dqViU98I3wsfzPXJ6C82oyX9m10nU5l06lC399jJt60ElHqeU9RplxqIY
MRJxPokX89YLgPS2+FHiL3wVX7n0S2dllwlP+aob/fCX4rI1r1OFt2XdwdHF
9TTgWRq90dMdrinwxy7a0FUQMm/TiZXUYZkkKFgyqEdp+Eal/sZ0P5N9flti
3OLnSIu4j2cHRdM1XlvGvkDIXUlty9CwHyRDySXPv6DG99OwdZYKI7r699RO
WhrDS0h5Gl5f+p0sdJbphBWrFLWibRsp7nO6nEcLnudbg6U7Zjj304TqCkWL
jdsOI5TdZGCA+NBc2dOpTC/lxAfAArYNEJlk4A5T8mPUcArlqLTxAtolrL8K
UXCe5tSgoDjanq249upXVPMeKauq4IejFY+u1fCJxlaXMGbmaB9Ekgeszsfq
SkuWa64KJX1DTtkP+dKNmjAr5hqtckM6N44eCKK+P6hFUNZMqlOSxm3XiKa/
adKTFDFGuegzdagatUiiXfI9VXb0oAnrdunnIcWo8bv0+1XPD12NXLuYXgiG
3waIGADyOHUczpdDlf9LiqJqMTT1B+PjMDdSAIiV7BnM48tRj37SblcaIB6a
hNJizaFD5hh++Xj5Q9kYttzvBZsoUhssKSw9j34irlOut9WJ2M2mmSGFYIBY
HiTEJn45eqM7LTrN/zdvI/V+kfosFbew7E1tdwtrZ5aeOmFrspAko9q/xRss
clhmA/nKa4UAN2YBHR5I/75PM53P0NhHqVISZXozvd2wz6zUT7OOsxCqx9WP
sCdGjGa6zZFj1nqBkN6B+ShznLStPQVVoGnKchhZadTsQarsjkG7RhvjqFis
zjpy9Wve20SlW7IpUO516jVbUSSFne2qPQe8qdk2xLjFzyF/DZCi6BqyYYBY
FAh5a3kTWyHhSZLnobTCcmFBNvK1dUDs9bvdzjKasJEUnSzIFpf8GUE1GtOX
7stO09gnKKgN7c+V/ZVrMLenavfS8J9lP9QzQHxprhu0tglN3K33KwBM8d0A
YcFiBnmNWGlsj6iUStHFfaoxos/TpPJSiTphRsTO0hzknacREdaWMEFBcj2o
0zI9tcTozFF3sl+n7yJ06uIxQaSKhWGiTyWdmGhSKVpM+zLKIns6mYKClNaN
FH2jVrTYO2vSAmRNEnxoVUcJ7MO1Cab8NkC0O+eK2wu7dkEv0/wDplriFZ1t
HH0kjy9bif4M1WMX/9C0p3ntbrJ7LbPc766f3FNWvZSQYJSFMANEaF71WkCC
wdWZZgbcALE8SIhN/GB6bKBeM9qa2gK2DBDrk8XzqnpjjDWLSdlKXQLbmOyk
QKfCJrOpn6TZh6y+GPtM3UpnN1ZRw3spmJ0QsdvbFSPm+ozlkWPWen5L74B9
lCku8yHiXs1Ik/ZA3E9nu1X6EonJq3Bal+X5mTgFtLOGTQFdgWysZlsX4xY/
h8cPA6RouobHsgFiSSCwvEx605BtnekoJAaYGyAW+912ZxlN2Mepz/d6I1PS
f9ShlIKWpZ7mWnXIt+bKoAH1TEsMA2CAbQNEupLpIYZJU9mAd89KKT+bThIt
plKyrKpsr68cdZ5CGw9SrnvzkKPzfxhGXihgHkFG6V5tGSAu7eI4fTGVjil9
uXWXYF3lQVcrYxq7USy/TpELJnC0gshoNblMu9No1XFrJ/5+GiCSOWCSmoBp
aOZ7TdYDQNzZ2Gwl+jMzQPSyb1nsd243dStFwfVo7Ne0P1M2Pq/QCWnXlJ2w
1OxJizbTnzIzxHmG/rG8N25VZ7Y+SKQRq6tf2ZvaArYMEOuTxeR6stIsegSy
MaV9FV0jiNlZ3pMqSJgYIGKbB3s2MG2LEXN9xvLIMWs9v6V3wD7KhHz6qYn+
yOdjtSbRr+xoj5kYRhJJEhrym9iaAt7VbIti3OLnSBf7bIAURdcwLBsgVgSC
uProefaypcT6RpYXA8RKv/vQWUYT1kjDYSnx9X6bu5XGL6Gzpi5YvjWX61f1
R9jbBQKAYTcLlnupZfPR8A+l65msc2uYvT6mceMoJcXzb9x7NLySZ8o499DQ
x4RXcgiRaB0pOVUd9GeC6BFkJL5sGiAeOMo5RtuW05pUmtOM1ytUSzALTFDJ
Z/YyCuVEWgL01QyZs5Dn/e3rlp5LztOhNbRuPi1MohYlCsEAYeaeeXJmae9F
P0pdQAzrsBAAIh64yLaCrWBmgLhHsq6+bd7vHGVOFWIchOEaHEqt+9OkZUqX
s1xaEyv4jAn/asRSl/dpkUHkuxGFZ4DoDh5bU5thS/uyOlmUr3orGiCSAf5i
P5r7mUKsuf6xAWPdQ8zMAJEeLTaaD2KkCAwQP6V3AD/KBEkceVHC2bg1vjPr
LHk7BNgAkWEmxi1+jngjXw2QoukaRkANELH+1Es0eaF6es7uzzem9YK2ATBA
fOgsowlr0D5e9B8VGnXIt+ZytUCNTwwXdwBMsGqAsLEq23n28oeSlsImrDhJ
rYkjLot+HEG9alPtEtJaVkUvBlMPUXcKnAHC0kFEVKHBM+iH3+h0tsESnEXT
KlGQ3BODhaH9hxbK63orm0WLTkP5YIAIqcb6vECvDaMvN9KhvyjvaKGcgIji
zrwmoPTJhiqf9QAQwdnYNQjFiCHLWDJAlI1jtd9dFsYO+qwrdahMTwWJw7Xi
67RGftzjpJMLaWwTiikrjedgnch3E4rYALE1tRn2tC+Lk0X5PreiAeJtOtvC
igEivrYPYqRIDBDyR3oH8KNMsJbE2+uCpZ0jgTdArIhxWznJfTZAiqZrGAE1
QKyqNxYIgAHiQ2fZNEC86D8qNOqQb80FAwT4jMUhp92jFo1lb1qK6IHgbUNJ
JJ8yz8t0S6EowJrhfB5Xi/FigTwBkVLIRo6QZZMwXoKzPqL6/6J2MynjKh/z
dXwmNXuUPvhFufJKW6ZeJLlcpbepITj30ugqfDIQeZKNQnLBYmPAyyYSOxQ2
OQGRAkBMjkgYzJ2pymDKsLma2DsBsdzvXA5lyspVuP579Hta0Jx/SXf0cd7f
isOOvFO0aw6fXcqWGaXz6P00ZL3szwNqgNib2gL2tC+Lk0X5qoVngPjemN52
hm1h4wTEBzFSaAaIp/X8lN4B/CgTrO1Ci0f23gwQ+Z6JvwZIHv0w2pOywKoY
9/sEJHMurfWay7pouobhrWXIjkDwcphrh7vhBMS35uJO0kfa1AQAWMCSAcKc
e4Op+zKPhmDiLsjDnHPc0UySkun14LthvM42eO5SPvWcJWcGYx9Idn/rBkje
Sv6h2vBSuZTjsmj9SeGtrtCceDp9hY5+QVO6UqtBlLqcjmrSp5g7jZNk6Cke
aktDEPaWdYLI5MLQScd+kbIF+mOASB6t5rUpxcxjJtG41iqbs/S2wU1p83nb
b2olBsTdI9b73fWTWis0Y9JJuzpT0FPCCMynNc1ohWZ9F7PO2jz9V/l7KDad
AmqA2Jva0vvY0L4sThblqxaeAeJPYzKfwIAU5rMSAyL6OvogRgrNAPG0np/S
O4AfZYIktbzYjCZBiyQlylPmVPHXAMmhqVHS31oX405rnyN9u7ZPj/SlGV5b
r2i6hmHeMuydLQsEMZwtEAUfAxgDYqOzbBogov5jsdk16lAAmwsAK1gxQLLn
8o7u6p1nZpUYKJZMh5FnoWSKqL4EK6DtXWh5Jj8jej+pSC0iIkw6SwaIURYI
hnUDRNJLtbKC7Q8zKed18dUiRi5r0+aQ5IgSpNwbt6MhiBsgmg8UN/SYYJHL
c38MEJVSpIuQEtD1krHTDQukiu9smlZXTK0cY62wggYzA0RIl+rJgmWn3y+m
0gNvazIbC4976X7RAFn7Mg3Si5d3zTvrBghb34vMALE7tcm9cmlaWH9HzvJk
kb9qoAyQwDYmyw5kZKxd/YoaaU1UA0wMEJZ/VZEFy64YCZABYtZ6fkvvgH2U
KSwTkf65rWv5eIuWCTsG7LxVP+0PM0+Uxzr2DBBmxRuo2bbEuMXPYf9ldpNt
A6SouobHtGXEd7YuEFhCP6NF6gy99XoRBqFbHns8vhkgkv6jP93+pqR2su/V
qkOBay4ArODFABFKsL3xAFXqrlP/iG1K61SXYMmu69CK07IfCmnVg2ro1GJw
plPMWMr+nzgjdFP1TnyKpu+z9kksD7ZeYsxTKUJuQysGiCSr1dv7rhnanJ67
R2OAZNB7j9HELRaCi4U6dJWK6eVxEt68ssrQs6MhiJ5ymnjqCzOpbnCADZCC
TRR7n1kACLMaXG8YOdKgfrQAq+thEgCSu4neeZpCEmmnr9sy4hpRhRaeUL0i
HU+mp4vJKgza6feLQhpe3YyFDzWl/ZelNLwGOVr/L9Xs5EhxuaDey5etc+Np
wBbZFYE1QOxObZLUBtXMcq2GPalmsI72ZXWyyF41UAZIwBszaybVu09xOuy+
zxet6BfLg1b06umhqQNykRbUJMf/0ay9MqXCrhgJkAFi1nr+S+9AfZQ5bAw/
Su9v1iQj2k8tRgsrEUklFMN1TKqcL6jBfdRnleJL7R4C8i4BspN6eSohe2Lc
4ucIsAM7j3Z6nb5uRlu8pf4Q7lUkXUNeWoZhSyCwkkbPaMvruPSB0TT4Z3t+
sH4aIDY6yzcDhCT9p4mOq8C5qZS0yTQNrw/NlUsbulD1jrRBU3gaAC+w+jK6
BghHOTtpcTw9V5w6z1A4w8txKYdDylP8p3RBVi55VyJf6HPZMb2x2l5dA9R1
h46v0r5Lwn+EGVH/DZq+TSbbnXR4MD2hFKTm8A60VantLDrnjvN10vGJ1PNj
6imU/Z2xlU79RTnud2Y+rkovIDGjS5hM13LdZArN/JlmPkuOxrTlAp16jyax
MhBCPbJnpDBk8V8laqybB8Z1n3FUtQzN3CUrKSuUzKjzrqcYsQg7aNB6KEl+
uYqzHiHnUlCQYnF0tXDi55Teg4IeoBFbybmFXnarvnofbgmXOBpmGCnAXaI9
0ynhEV7nH7rM8OyDh+0l6vpxXaO/1lDa61S6Co1YIRtg9hHXiHrU7V36WbbF
dGoShZWgrgsUb2i93/k6IP+PYpIpXZY+kfubPg2nlF9Er3jeAKlLA+fKhqKr
R9ZQXIgdX7IbtLmlrHxVDi1sR7svyS6wNUjIc9CjXy6HvaStqS2M/4eKy8wx
l8Yyg3p/QzMr8gdMKd/R73/ShTzPxVYni/Sq2hHCzqRsVYThKYTGzJxFsaVl
tYOFvJpLW1PqXqvqDUlq1Yud+bwHboOdu0ArX6VidWnOPh1nPxtixGim2/1Y
k9YLiPT26aPG77B2czdCNeoSz9JU2as6j9D4Top9NlcnLouhkp1pl1vZE3bk
2paht1eqxZp4bKGxGsRjC81GDfMrEMumCNrdeHcpIrti3Nrn8C9zglLKeyoT
OdOpyTTLCVSLpmvMW4Z8EQgsoEZRGdz1LeOpYZrp2qSE3Vz7ULv9brWzzCds
FVryp+GrskroJTrRNvfCxNG5L6nNZ4rvFd9Q8+a2mkv8/ADFwYG7hCtLqGEI
NS7rUQBqNKHQUAoJEf/VLUMN2tCA6d6TKHLZtHUkdapJnQZT71iqEUGjFhsX
v86njK9pchxVb0dJA6hDJI1cKtPNMmhADB2/zAeldmjIX9CjBYXHUup6G4JC
/lYda1HCEIpvSVG96fsjlH+cBjxIYc35D4x9iza6JEMmTa5NTctLiVJdWlAb
Wn5KetnTtKo/tX6e2veXbvI73xquCT41hkJa0NTNkgzJo71jqNEL1HeoohR4
LLvz4zRsnXpjMG8fLejIN1efodQngmp0p4XK7KzcDurxvKyPXO/Wgt76hv80
xTuXo4jXqOHHdEV6k0MzaEA4VWvPN2CXGJq8Tmi9XPq5H0VVp95pgnqj/XB2
c28Nm5VKdULUf+geNq5/rzxNpf6PWvamSUuNHfuv05pW/MURpcSvCw6lprGe
m9R7lsrXoPaDaKaVQure8GxSXaIdIyi6LcXHU0IYtRtGqw7rVCiw2O9XF1Dt
hXTjv/R9IkV05u/p6vHwQfTd71IzFtDmDjT/GOVuoSmx1HEAPyq61qMBn2jW
a69cpvRh1K4qxQ+l6Dc92022B8l1WtaE7yN3zi5+4r/sGfNy7E1t1yI1ix94
7frxTeFq5MX7Kf8qv1/HZEtsAi08IFxpcbJcUb5qsDBzB9Hpa7QtgR8h1e+R
fUI72n7J4MUKrzFlI8c1nRf1otdq8AInKZqaj6Yd5yy/j4B7X/f6GZrvasBE
Xvq5bugaLQeNvRO9ihEjEef7xxq0XgClt+2PYmOjrZ0xwNHZb/mVqFpT/im9
GtHQ+Xr7bK4FawmNbEQ1OlFiL+pYk7p8QFuVa+LpcRRa1ZP1q2IENYrlW5gt
sioR99FOzwucW0KDa1NEV+rbhEZsUC4QFsW43c8RdN1PX6dKr9CAQRQ90UYu
PvG9iqRr9FvGD4HgGtVbJojSyTUsIzrSwl3WShAWKG8uPJQtlD72O3nrLIsT
VpiY/Ofr+vFeph0f8N8b050ft5EtKW2zp5tUb+h+c1+a6zx92ZhKRdHy3y00
JgAg4AgbVhUnUo7eOuuS2J834n3PrGTxAoWBeRYsUKRgshhgFoQOAAAAAKAk
ezqVrGBWC4PbSR1K2qiJDAILDJBbB0wWI2CAAAAAAMA6p5P5PVuzzHWCd7T1
msggsMAAuXXAZDECBggAAAAArOPcRG+UUidF8SBk3yoRcjd6ldwiwAC5dcBk
MQIGCAAAAABskfsDJZSn/l+oQ3Tz/6atQ6lCJC06dNft6N46iJk6ou0EQoJC
A5NFBym3T9gky1mJAAAAAHDXw2XTr6k0pomY4KtVKyHP0kCauYGy/UghC/zB
KFEJuLlgsngwyu1jrUglAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAKHL+P8GF1EI=
    "], {{0, 182.71698113207546`}, {724.754716981132, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{724.754716981132, 182.71698113207546`},
  PlotRange->{{0, 724.754716981132}, {0, 182.71698113207546`}}]], "Text",
 CellChangeTimes->{3.9547289833023987`*^9, 3.9547318536950836`*^9, 
  3.95474566857682*^9, 3.955504290685812*^9, 3.9575716205752983`*^9, 
  3.959927059750223*^9},ExpressionUUID->"27562332-302c-684c-a6e9-\
c7f5988655e4"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnQdUFNf3+Hf9G4UTYn4kRxMTNTGGiARjAsaEEmUtNEPRiBpFoqJYsC2I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    "], {{0, 54.33962264150943}, {717.2830188679245, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{717.2830188679245, 54.33962264150943},
  PlotRange->{{0, 717.2830188679245}, {0, 54.33962264150943}}]], "Text",
 CellChangeTimes->{3.9599270147592373`*^9, 
  3.959927973580574*^9},ExpressionUUID->"ab0aa141-f81e-a441-ab20-\
bf3fed10f65e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptE", "=", 
  RowBox[{"Medio", "[", 
   RowBox[{"ptB", ",", "ptD"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.955532028301876*^9, 3.955532030902384*^9}, {
  3.959926974895401*^9, 3.959926980431593*^9}},
 CellLabel->
  "In[571]:=",ExpressionUUID->"3e8dd887-2087-0a47-896d-8880febfaa56"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["c", "2"], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "t"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], " ", 
     SuperscriptBox["b", "2"], " ", "t"}], "+", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "t"}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", "t", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "t"}], ")"}]}]}], ",", 
   RowBox[{"t", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["c", "2"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "t"}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.9555320321457787`*^9, 3.9575744904326897`*^9, 3.957576361903036*^9, 
   3.957577380717657*^9, {3.9575801708501434`*^9, 3.957580186537068*^9}, 
   3.959926981435324*^9, 3.9611523607923546`*^9, 3.961413548249255*^9},
 CellLabel->
  "Out[571]=",ExpressionUUID->"7ef689c9-7867-425a-abb3-be791704fdcb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FGHI tangential  trapezoid ", "Section",
 CellChangeTimes->{{3.95553234842535*^9, 3.955532366934231*^9}, {
   3.959927157703043*^9, 3.959927160382084*^9}, {3.9599278477683144`*^9, 
   3.9599278552150707`*^9}, 
   3.9599279019373302`*^9},ExpressionUUID->"b5d6f037-0b86-3a4b-a784-\
d8d7e12142d1"],

Cell[CellGroupData[{

Cell["X (3)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.957574457314209*^9, 
   3.9575744574718914`*^9}, 3.9599270895589314`*^9, {3.959927991440222*^9, 
   3.959927991493744*^9}},ExpressionUUID->"26d693a1-efa1-f940-912f-\
5ff54b61df69"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"3", ",", "ptE"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9575745870248795`*^9, 3.9575746314661713`*^9}, {
  3.957574709684349*^9, 3.957574739857065*^9}, {3.957574847378495*^9, 
  3.9575748625135956`*^9}, {3.959927095008583*^9, 3.959927100167317*^9}, {
  3.9599279944569798`*^9, 3.959927994522417*^9}},
 CellLabel->
  "In[572]:=",ExpressionUUID->"4844a206-ce5e-244e-a645-125911b000b4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "t"}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "t"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"3", " ", "t"}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "t"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", "t"}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "t"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "2"]}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t"}], ")"}]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", "t"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"], " ", "t"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "t"}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "t"}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "t"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "t"}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "t"}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      SuperscriptBox["c", "4"], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "t"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "t"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", "t"}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "2"]}], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      SuperscriptBox["c", "6"], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", "t", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "t"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "t"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "t", " ", 
          RowBox[{"(", 
           RowBox[{"4", "+", "t"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", 
            RowBox[{"2", " ", "t"}], "+", 
            SuperscriptBox["t", "2"]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["b", "4"], " ", "t"}], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", "t"}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", "t", " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "t"}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{"3", " ", "t"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "t", " ", 
            RowBox[{"(", 
             RowBox[{"4", "+", "t"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"2", "+", "t", "+", 
              SuperscriptBox["t", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"], " ", "t"}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["t", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox["t", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "6"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "t"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"5", " ", "t"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["t", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "t", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "t"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "-", 
            RowBox[{"2", " ", "t"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["t", "2"]}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
         SuperscriptBox["c", "3"]}], ")"}], "2"], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", "t", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "t"}], ")"}]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["c", "4"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "t"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "t"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "t", " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            RowBox[{"3", " ", "t"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", 
            RowBox[{"2", " ", "t"}], "+", 
            SuperscriptBox["t", "2"]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "4"], " ", "t"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", "t"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"2", " ", "t"}]}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "t", " ", 
            RowBox[{"(", 
             RowBox[{"3", "+", 
              RowBox[{"2", " ", "t"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", "t", "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["t", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["t", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], " ", 
       SuperscriptBox["t", "2"]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "2"], " ", "t"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", "t"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["t", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "-", 
            RowBox[{"2", " ", "t"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["t", "2"]}]}], ")"}]}]}], ")"}]}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.959927113709245*^9, 3.959927995347643*^9, 3.9611522905006275`*^9, 
   3.961152443737114*^9, {3.9611533304166775`*^9, 3.9611533329700184`*^9}, 
   3.961153380248209*^9, 3.961413548558024*^9},
 CellLabel->
  "Out[572]=",ExpressionUUID->"6ccf9b44-03fc-41cf-af6b-fc4665afdc57"]
}, Open  ]],

Cell["FGHI  is  a  trapezoid with FG || HI", "Text",
 CellChangeTimes->{{3.959927448507843*^9, 3.959927475342945*^9}, {
  3.959928248975962*^9, 
  3.959928258327595*^9}},ExpressionUUID->"d977ce88-08cc-f244-8e28-\
5843bf1f0d1e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonParalelas", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptF", ",", "ptG"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptI", ",", "ptH"}], "]"}]}], "]"}], ",", "Hjelmslev"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9611532375193176`*^9, 3.961153240807907*^9}},
 CellLabel->
  "In[573]:=",ExpressionUUID->"b701cab8-72dc-5642-99ca-c9ef2c44438e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9611532418464355`*^9, 3.9611533379748745`*^9, 
  3.9611533824200745`*^9, 3.9614135485960293`*^9},
 CellLabel->
  "Out[573]=",ExpressionUUID->"7a8d172d-58d0-4249-bbd4-3cf70296c160"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (69)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.957574457314209*^9, 
   3.9575744574718914`*^9}, 3.9599270895589314`*^9, {3.959927991440222*^9, 
   3.959927991493744*^9}, {3.959928224616413*^9, 
   3.9599282265360317`*^9}},ExpressionUUID->"08b334a4-d5b8-7342-8386-\
1db35a3f4abd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"69", ",", "ptE"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9575745870248795`*^9, 3.9575746314661713`*^9}, {
  3.957574709684349*^9, 3.957574739857065*^9}, {3.957574847378495*^9, 
  3.9575748625135956`*^9}, {3.959927095008583*^9, 3.959927100167317*^9}, {
  3.9599279944569798`*^9, 3.959927994522417*^9}, {3.959928229257004*^9, 
  3.959928230496792*^9}},
 CellLabel->
  "In[574]:=",ExpressionUUID->"f291346a-7b0d-ed47-b2a3-5a8c664dffc7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", 
       SuperscriptBox["c", "6"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"3", " ", "t"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["t", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["t", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "t"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            RowBox[{"2", " ", "t"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["t", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"5", " ", "t"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"5", " ", "t"}], "-", 
            RowBox[{"6", " ", 
             SuperscriptBox["t", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", "t", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"4", " ", "t"}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "t"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["t", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", "t"}]}], ")"}], "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", "t", " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "t"}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "t", " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", "t"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"4", " ", "t"}], "+", 
           SuperscriptBox["t", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"t", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "t"}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], " ", "t"}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "t"}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "t"}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "t"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", "t"}]}], ")"}], "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", "t"}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"3", " ", "t"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"4", " ", "t"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["t", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"], " ", "t"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "6"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "t"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"5", " ", "t"}]}], ")"}]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["t", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"3", " ", "t"}], "+", 
         SuperscriptBox["t", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "6"}], " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["t", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "t", " ", 
          RowBox[{"(", 
           RowBox[{"5", "+", 
            RowBox[{"2", " ", "t"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "6"}], "-", 
            RowBox[{"5", " ", "t"}], "+", 
            SuperscriptBox["t", "2"]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "t", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", "t", " ", 
          RowBox[{"(", 
           RowBox[{"4", "+", 
            RowBox[{"3", " ", "t"}]}], ")"}]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"4", " ", "t"}], "+", 
            SuperscriptBox["t", "2"]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t"}], ")"}]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["c", "2"], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "t"}]}], ")"}], "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", "t"}]}], ")"}], "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "t"}], ")"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"3", " ", "t"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["c", "6"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"], " ", "t"}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"3", " ", "t"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       SuperscriptBox["t", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "t", "+", 
         SuperscriptBox["t", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", "t", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "t", " ", 
          RowBox[{"(", 
           RowBox[{"4", "+", "t"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            SuperscriptBox["t", "2"]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["t", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "t", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "t"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"2", "-", 
            RowBox[{"3", " ", "t"}], "+", 
            SuperscriptBox["t", "2"]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "6"]}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "t", "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["t", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["t", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "t"}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", "t"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", "t", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"4", " ", "t"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["t", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       SuperscriptBox["t", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"4", "+", "t"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"3", " ", "t"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["t", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["c", "2"], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", "t"}]}], ")"}], "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "+", "t"}], ")"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "t", " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", "t"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"t", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["c", "2"], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "t"}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "t"}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"]}], "+", 
           SuperscriptBox["b", "2"]}], ")"}], " ", "t"}]}], ")"}]}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.959927113709245*^9, 3.959927995347643*^9, 
  3.9599282426686788`*^9, 3.9611524823953667`*^9, 3.9611531039366207`*^9, 
  3.9611533666814003`*^9, 3.9614135489399157`*^9},
 CellLabel->
  "Out[574]=",ExpressionUUID->"2491fce4-ce37-4a2a-858d-5de214985454"]
}, Open  ]],

Cell["FGHI  is  a  trapezoid  with FI || GH", "Text",
 CellChangeTimes->{{3.959927448507843*^9, 3.959927475342945*^9}, {
  3.959928264384104*^9, 
  3.959928297077116*^9}},ExpressionUUID->"5fad4a59-e13b-e945-829d-\
6b5214f3e7ef"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"SonParalelas", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptF", ",", "ptI"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"ptG", ",", "ptH"}], "]"}]}], "]"}], ",", "Hjelmslev"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9599271748115997`*^9, 3.9599271935832763`*^9}, {
  3.959928002050028*^9, 3.9599280155614014`*^9}, {3.9599282050663395`*^9, 
  3.959928211026394*^9}, {3.959928280523222*^9, 3.9599282857858734`*^9}},
 CellLabel->
  "In[575]:=",ExpressionUUID->"648bd8a4-6fed-5d4d-9291-6edf17bb4e5d"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.9599271951351624`*^9, {3.9599279979722195`*^9, 3.959928017468786*^9}, 
   3.9599282119226875`*^9, {3.959928267437769*^9, 3.959928286803064*^9}, 
   3.961152486730648*^9, 3.961153106220585*^9, 3.961153369490841*^9, 
   3.961413549024075*^9},
 CellLabel->
  "Out[575]=",ExpressionUUID->"4c6bc559-4053-444d-a823-9f1869256453"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FGHI tangential  trapezoid with incenter E", "Section",
 CellChangeTimes->{{3.95553234842535*^9, 3.955532366934231*^9}, {
  3.959927157703043*^9, 3.959927160382084*^9}, {3.9599278477683144`*^9, 
  3.9599278552150707`*^9}},ExpressionUUID->"c59d6c3a-6d51-4444-9820-\
9f8160119815"],

Cell[CellGroupData[{

Cell["X (4)", "Subsection",
 CellChangeTimes->{{3.9547318899015656`*^9, 3.954731893974074*^9}, {
   3.95473265785647*^9, 3.954732659663503*^9}, {3.954732890679308*^9, 
   3.954732891487614*^9}, 3.954733054504549*^9, 3.954734909088499*^9, {
   3.9547456826790233`*^9, 3.954745683267832*^9}, {3.957574457314209*^9, 
   3.9575744574718914`*^9}, 
   3.9599270895589314`*^9},ExpressionUUID->"d11bcbe3-4466-8d48-8d95-\
b256984be2d3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptF", ",", "ptG", ",", "ptH", ",", "ptI"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"centralQuadrilateral", "[", 
    RowBox[{"4", ",", "ptE"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9575745870248795`*^9, 3.9575746314661713`*^9}, {
  3.957574709684349*^9, 3.957574739857065*^9}, {3.957574847378495*^9, 
  3.9575748625135956`*^9}, {3.959927095008583*^9, 3.959927100167317*^9}},
 CellLabel->
  "In[576]:=",ExpressionUUID->"745a30b3-f1a0-bf42-9ffa-c1b54561d882"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"]}], ")"}], " ", "t"}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", "t"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "4"], " ", "t"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"], " ", "t"}], "-", 
             RowBox[{
              SuperscriptBox["c", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"2", " ", "t"}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["b", "2"]}], " ", "t", " ", 
              RowBox[{"(", 
               RowBox[{"3", "+", 
                RowBox[{"2", " ", "t"}]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["c", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", "t", "+", 
                RowBox[{"2", " ", 
                 SuperscriptBox["t", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t"}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "t"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "t"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], "+", 
             SuperscriptBox["b", "2"]}], ")"}], " ", 
           SuperscriptBox["t", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["c", "4"], " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", 
             RowBox[{"3", " ", "t"}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", "t", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             RowBox[{
              SuperscriptBox["a", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{"3", " ", "t"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}], " ", "t"}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "t"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["a", "2"]}], "+", 
           SuperscriptBox["b", "2"]}], ")"}], " ", 
         SuperscriptBox["t", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", 
           RowBox[{"3", " ", "t"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "t", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"1", "+", 
              RowBox[{"3", " ", "t"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "t"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", "t", " ", 
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"2", " ", "t"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["b", "2"], " ", "t"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"3", "+", "t"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "t"}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "t"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", "t", " ", 
           RowBox[{"(", 
            RowBox[{"3", "+", 
             RowBox[{"2", " ", "t"}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              SuperscriptBox["b", "2"], " ", "t"}], "+", 
             RowBox[{
              SuperscriptBox["c", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"3", "+", "t"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], "+", 
          SuperscriptBox["c", "2"], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"2", " ", "t"}]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["b", "4"], " ", "t"}], "+", 
          RowBox[{
           SuperscriptBox["c", "4"], " ", "t"}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", "t", " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", "t"}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"2", "+", 
             RowBox[{"3", " ", "t"}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["b", "2"]}], " ", "t", " ", 
              RowBox[{"(", 
               RowBox[{"4", "+", "t"}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["c", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"2", "+", "t", "+", 
                SuperscriptBox["t", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"2", " ", "t"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", "t"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "t"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t"}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "t"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "t"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", "t"}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t"}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", "t"}]}], ")"}]}]}], ")"}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "t"}], ")"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "6"], " ", "t"}], "-", 
      RowBox[{
       SuperscriptBox["c", "6"], " ", "t"}], "-", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"3", " ", "t"}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", "t", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"3", " ", "t"}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["b", "4"], " ", "t", " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", "t"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"2", "+", 
            RowBox[{"4", " ", "t"}], "-", 
            SuperscriptBox["t", "2"]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "t", "+", 
            SuperscriptBox["t", "2"]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "2"], " ", "t", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "t"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "-", "t", "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["t", "2"]}]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "6"]}], " ", "t"}], "+", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", "t"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", "t"}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", "t", " ", 
          RowBox[{"(", 
           RowBox[{"3", "+", 
            RowBox[{"2", " ", "t"}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "t", "+", 
            SuperscriptBox["t", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "4"}], "+", "t", "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["t", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "t"}], ")"}], " ", "t"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"4", " ", "t"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["t", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "t"}], ")"}]}], "-", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "t"}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", "t"}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox["c", "4"], "-", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", "t"}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", "t"}], ")"}]}], "+", 
             RowBox[{"3", " ", 
              SuperscriptBox["b", "2"], " ", "t"}]}], ")"}]}]}], ")"}]}], 
       ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"]}], ")"}], " ", "t"}], "+", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"2", "+", "t"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", "t"}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "1"}], "+", "t"}], ")"}]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", "t"}]}], ")"}]}]}], ")"}]}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.959927113709245*^9, 3.9611529715154552`*^9, 
  3.9611534032747097`*^9, 3.961153501476969*^9, 3.961413549361115*^9},
 CellLabel->
  "Out[576]=",ExpressionUUID->"b0a901e8-41a8-4b4a-9499-5932f34fc90b"]
}, Open  ]],

Cell["FGHI  is  a  trapezoid with FI || GH", "Text",
 CellChangeTimes->{{3.959927448507843*^9, 3.959927475342945*^9}, {
  3.959928406678236*^9, 
  3.959928411352535*^9}},ExpressionUUID->"08c071f4-252b-aa43-be49-\
a0ca56e11356"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SonParalelas", "[", 
  RowBox[{
   RowBox[{"Recta", "[", 
    RowBox[{"ptF", ",", "ptI"}], "]"}], ",", 
   RowBox[{"Recta", "[", 
    RowBox[{"ptG", ",", "ptH"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9599271748115997`*^9, 3.9599271935832763`*^9}},
 CellLabel->
  "In[577]:=",ExpressionUUID->"285c8516-1343-ef41-889d-377d6b76f101"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9599271951351624`*^9, 3.9611529744866104`*^9, 
  3.9611534062722664`*^9, 3.961153503293192*^9, 3.961413549433864*^9},
 CellLabel->
  "Out[577]=",ExpressionUUID->"abb9f1be-0168-44c0-99ff-0a99b51a35d0"]
}, Open  ]],

Cell["\<\
FGHI  is  a  tangential quad with center E, since point E is equidistant from \
lines FG, GH, HI, IF\
\>", "Text",
 CellChangeTimes->{{3.959927448507843*^9, 3.959927497439813*^9}, {
  3.959927528416189*^9, 
  3.9599275516793833`*^9}},ExpressionUUID->"ac906af1-03bc-9b47-8793-\
0b27eca0927c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dEFG2", "=", 
  RowBox[{"CuadradoDistanciaPuntoRecta", "[", 
   RowBox[{"ptE", ",", 
    RowBox[{"Recta", "[", 
     RowBox[{"ptF", ",", "ptG"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.959927234244898*^9, 3.959927290551951*^9}},
 CellLabel->
  "In[578]:=",ExpressionUUID->"6c09188a-3ff5-f747-97e8-6faef00bca5d"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "t"}]}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["c", "2"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "t"}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "t"}]}], ")"}], "2"]}], 
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["c", "2"], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", "t"}], "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "t"}], "+", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", "t"}], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["t", "2"]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["c", "4"], "+", 
     RowBox[{
      SuperscriptBox["a", "4"], " ", "t"}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"], " ", "t"}], "+", 
     RowBox[{
      SuperscriptBox["b", "4"], " ", "t"}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", "t"}], "+", 
     RowBox[{
      SuperscriptBox["c", "4"], " ", "t"}], "+", 
     RowBox[{
      SuperscriptBox["a", "4"], " ", 
      SuperscriptBox["t", "2"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{
  3.959927254172426*^9, 3.959927291929079*^9, {3.9611534957891865`*^9, 
   3.961153505609434*^9}, 3.9614135496011763`*^9},
 CellLabel->
  "Out[578]=",ExpressionUUID->"b416e076-6399-4a9a-8d06-d4895d4c7777"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dEGH2", "=", 
  RowBox[{"CuadradoDistanciaPuntoRecta", "[", 
   RowBox[{"ptE", ",", 
    RowBox[{"Recta", "[", 
     RowBox[{"ptG", ",", "ptH"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9599272996161194`*^9, 3.959927311496252*^9}},
 CellLabel->
  "In[579]:=",ExpressionUUID->"1edc746d-af50-bc47-9b64-cd43312195a5"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     SuperscriptBox["b", "2"], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", "t"}]}], ")"}], "2"], 
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["c", "2"], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", "t"}], "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "t"}], "+", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", "t"}], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["t", "2"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{{3.959927300809395*^9, 3.959927312474676*^9}, 
   3.9611535141870747`*^9, 3.961413549634942*^9},
 CellLabel->
  "Out[579]=",ExpressionUUID->"323df57b-5bd2-4d7f-ba82-af3eead735b6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dEHI2", "=", 
  RowBox[{"CuadradoDistanciaPuntoRecta", "[", 
   RowBox[{"ptE", ",", 
    RowBox[{"Recta", "[", 
     RowBox[{"ptH", ",", "ptI"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9599273176898003`*^9, 3.9599273249770603`*^9}},
 CellLabel->
  "In[580]:=",ExpressionUUID->"6d0d8535-6938-684e-9954-b7e60f27649c"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "t"}]}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["c", "2"], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", "t"}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", "t"}]}], ")"}], "2"]}], 
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["c", "2"], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", "t"}], "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "t"}], "+", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", "t"}], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["t", "2"]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["c", "4"], "+", 
     RowBox[{
      SuperscriptBox["a", "4"], " ", "t"}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"], " ", "t"}], "+", 
     RowBox[{
      SuperscriptBox["b", "4"], " ", "t"}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", "t"}], "+", 
     RowBox[{
      SuperscriptBox["c", "4"], " ", "t"}], "+", 
     RowBox[{
      SuperscriptBox["a", "4"], " ", 
      SuperscriptBox["t", "2"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.959927325861391*^9, 3.9611535162052937`*^9, 
  3.961413549896213*^9},
 CellLabel->
  "Out[580]=",ExpressionUUID->"595a7418-abed-44a8-b987-a2bf825e650f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dEIF2", "=", 
  RowBox[{"CuadradoDistanciaPuntoRecta", "[", 
   RowBox[{"ptE", ",", 
    RowBox[{"Recta", "[", 
     RowBox[{"ptI", ",", "ptF"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.959927335128837*^9, 3.959927341344187*^9}},
 CellLabel->
  "In[581]:=",ExpressionUUID->"f558bb35-a1e6-0f47-8d72-f926f2745b0c"],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["c", "2"], "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "t"}], "+", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", "t"}]}], ")"}], "2"], 
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["c", "2"], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", "t"}], "-", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", "t"}], "+", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", "t"}], "+", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["t", "2"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.9599273422588234`*^9, 3.9611535180653*^9, 
  3.9614135499296227`*^9},
 CellLabel->
  "Out[581]=",ExpressionUUID->"a386d76e-d08a-4ff8-bff6-db8c3d5d49cd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"dEFG2", "-", "dEGH2"}], "]"}], ",", "Hjelmslev"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.959927353561844*^9, 3.959927401768297*^9}},
 CellLabel->
  "In[582]:=",ExpressionUUID->"4c9cd8b0-b37a-ca49-80d8-70c8a25a82b0"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.9599273800305634`*^9, 3.9599274027234154`*^9}, 
   3.9611535240702744`*^9, 3.9614135499661293`*^9},
 CellLabel->
  "Out[582]=",ExpressionUUID->"18b26402-576a-4d0d-a96b-f911b1751bb0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"dEGH2", "-", "dEHI2"}], "]"}], ",", "Hjelmslev"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9599274153127117`*^9, 3.959927420728201*^9}},
 CellLabel->
  "In[583]:=",ExpressionUUID->"68354e3d-ad27-4345-8581-9d31da974d93"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.959927421712408*^9, 3.961153525306196*^9, 
  3.961413549997224*^9},
 CellLabel->
  "Out[583]=",ExpressionUUID->"88713b4d-8932-4aa3-a7b8-2c8c94469e20"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"dEHI2", "-", "dEIF2"}], "]"}], ",", "Hjelmslev"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.959927426632145*^9, 3.959927433440336*^9}},
 CellLabel->
  "In[584]:=",ExpressionUUID->"cc838989-cf85-5f47-9262-8098b3d80cb8"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9599274344072113`*^9, 3.9611535265543003`*^9, 
  3.9614135500043497`*^9},
 CellLabel->
  "Out[584]=",ExpressionUUID->"75ca588d-6aaf-4ba2-966c-b903743889c1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Factor", "[", 
    RowBox[{"dEIF2", "-", "dEFG2"}], "]"}], ",", "Hjelmslev"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9599275901922245`*^9, 3.959927593632986*^9}},
 CellLabel->
  "In[585]:=",ExpressionUUID->"9fae3d6a-98e9-1d47-bde8-4c8d723098ab"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9599275943680305`*^9, 3.9611535276596775`*^9, 
  3.961413550036165*^9},
 CellLabel->
  "Out[585]=",ExpressionUUID->"98d6a6d3-f33c-4e04-a9c5-eb67eb19a123"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnQl4FEXaxxM+QXiMuLjLsx+KirIoRHB3CYogSgIIJBgOMRwBIocESDgD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    "], {{0, 31.245283018867923`}, {622.8679245283018, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{622.8679245283018, 31.245283018867923`},
  PlotRange->{{0, 622.8679245283018}, {0, 31.245283018867923`}}]], "Input",
 CellLabel->
  "In[586]:=",ExpressionUUID->"a38a26e4-ec0a-c64e-b19b-7463a33c28c6"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnQl4FEXaxxM+QXiMuLjLsx+KirIoRHB3CYogSgIIJBgOMRwBIocESDgD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    "], {{0, 31.245283018867923`}, {622.8679245283018, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.}],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{622.8679245283018, 31.245283018867923`},
  PlotRange->{{0, 622.8679245283018}, {0, 31.245283018867923`}}]], "Output",
 CellChangeTimes->{3.961413550042601*^9},
 CellLabel->
  "Out[586]=",ExpressionUUID->"4f89e226-3658-4532-b9a4-c439503f2796"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptU", "=", 
  RowBox[{"Pie", "[", 
   RowBox[{"ptE", ",", 
    RowBox[{"Recta", "[", 
     RowBox[{"ptF", ",", "ptI"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.959927636976301*^9, 3.959927670089424*^9}},
 CellLabel->
  "In[587]:=",ExpressionUUID->"d3d162b5-312d-cb49-a90c-346a609d0955"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "2"]}], "+", 
       SuperscriptBox["b", "2"]}], ")"}], " ", "t"}], "-", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", "t"}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", "t"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "t"}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "t"}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "t"}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", "t"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["a", "2"], "-", 
         SuperscriptBox["b", "2"]}], ")"}], " ", "t"}], "+", 
      RowBox[{
       SuperscriptBox["c", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", "t"}], ")"}]}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9599276584440827`*^9, 3.9599276703649693`*^9}, 
   3.9611536305837135`*^9, 3.961413550074791*^9},
 CellLabel->
  "Out[587]=",ExpressionUUID->"9a6e806b-4885-4f0a-926c-41daad947a4b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptV", "=", 
  RowBox[{"Pie", "[", 
   RowBox[{"ptE", ",", 
    RowBox[{"Recta", "[", 
     RowBox[{"ptG", ",", "ptH"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.959927674524637*^9, 3.959927686232918*^9}},
 CellLabel->
  "In[588]:=",ExpressionUUID->"24c95e72-cc2e-d946-b728-2178fbc80ca0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["b", "2"], "-", 
    SuperscriptBox["c", "2"], "-", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "t"}]}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "t"}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "t"}], ")"}]}], "-", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "t"}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", "t"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], "+", 
      SuperscriptBox["c", "2"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "t"}]}], ")"}]}]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{3.959927686558468*^9, 3.961153631477482*^9, 
  3.96141355011622*^9},
 CellLabel->
  "Out[588]=",ExpressionUUID->"b6abcc76-02d0-435f-8af5-65c424a103f4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EstanAlineados", "[", 
  RowBox[{"{", 
   RowBox[{"ptB", ",", "ptD", ",", "ptU", ",", "ptV"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.959927815512377*^9, 3.959927828593109*^9}},
 CellLabel->
  "In[589]:=",ExpressionUUID->"2eb77c89-7e79-a64a-af37-e43a5f79565e"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.959927829623535*^9, 3.9611536328988056`*^9, 
  3.961413550146908*^9},
 CellLabel->
  "Out[589]=",ExpressionUUID->"6610ea31-c814-4cb8-9aa6-5ae72b8463ef"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
WindowSize->{1294, 655},
WindowMargins->{{267, Automatic}, {Automatic, 103}},
FrontEndVersion->"14.2 for Mac OS X x86 (64-bit) (March 16, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5c23008d-16ad-134f-909e-88e5f16e4aae"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 480, 7, 96, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[1063, 31, 1527, 26, 164, "Text",ExpressionUUID->"22c83543-03f0-524a-b077-52bf40ea5d06"],
Cell[CellGroupData[{
Cell[2615, 61, 223, 4, 66, "Section",ExpressionUUID->"4726c28a-23e3-c144-b5b8-1febfd23a730"],
Cell[2841, 67, 1409, 29, 49, "Input",ExpressionUUID->"fe7e3f24-57f0-1445-8125-872b46d33312"],
Cell[4253, 98, 319, 6, 33, "Text",ExpressionUUID->"54ce8b45-a9ff-364a-b007-50e763233c41"],
Cell[CellGroupData[{
Cell[4597, 108, 391, 8, 29, "Input",ExpressionUUID->"2b97bda7-fc4c-854c-a342-fa797e627188"],
Cell[4991, 118, 887, 15, 70, "Output",ExpressionUUID->"ab8f45db-0ad0-42e9-8443-21607396166a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5915, 138, 691, 16, 49, "Input",ExpressionUUID->"d4990506-4c5e-3c4f-ae15-03b45e912fc7"],
Cell[6609, 156, 758, 21, 70, "Output",ExpressionUUID->"397c396c-daec-4b98-8fcb-1e4698f0d308"]
}, Open  ]],
Cell[7382, 180, 356, 10, 29, "Input",ExpressionUUID->"9417ba84-3d4a-9f4f-8034-96c53bd2f1bf"]
}, Closed]],
Cell[CellGroupData[{
Cell[7775, 195, 255, 4, 52, "Section",ExpressionUUID->"fc2fcd82-4d50-ec47-b5a7-8944aef04ea5"],
Cell[8033, 201, 5246, 140, 238, "Input",ExpressionUUID->"c44d3c99-d821-aa44-a5bf-67b591807924"]
}, Closed]],
Cell[CellGroupData[{
Cell[13316, 346, 211, 4, 52, "Section",ExpressionUUID->"2609bf4c-7f5c-314e-a744-f86d4be283dd"],
Cell[13530, 352, 28650, 475, 153, "Text",ExpressionUUID->"f2a821f3-330a-5649-abcf-5dc2575a85c9"],
Cell[42183, 829, 67750, 1115, 197, "Text",ExpressionUUID->"27562332-302c-684c-a6e9-c7f5988655e4"],
Cell[109936, 1946, 24986, 415, 69, "Text",ExpressionUUID->"ab0aa141-f81e-a441-ab20-bf3fed10f65e"],
Cell[CellGroupData[{
Cell[134947, 2365, 309, 7, 29, "Input",ExpressionUUID->"3e8dd887-2087-0a47-896d-8880febfaa56"],
Cell[135259, 2374, 1003, 30, 35, "Output",ExpressionUUID->"7ef689c9-7867-425a-abb3-be791704fdcb"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[136311, 2410, 300, 5, 66, "Section",ExpressionUUID->"b5d6f037-0b86-3a4b-a784-d8d7e12142d1"],
Cell[CellGroupData[{
Cell[136636, 2419, 473, 7, 53, "Subsection",ExpressionUUID->"26d693a1-efa1-f940-912f-5ff54b61df69"],
Cell[CellGroupData[{
Cell[137134, 2430, 584, 12, 29, "Input",ExpressionUUID->"4844a206-ce5e-244e-a645-125911b000b4"],
Cell[137721, 2444, 11473, 359, 194, "Output",ExpressionUUID->"6ccf9b44-03fc-41cf-af6b-fc4665afdc57"]
}, Open  ]],
Cell[149209, 2806, 227, 4, 33, "Text",ExpressionUUID->"d977ce88-08cc-f244-8e28-5843bf1f0d1e"],
Cell[CellGroupData[{
Cell[149461, 2814, 443, 12, 29, "Input",ExpressionUUID->"b701cab8-72dc-5642-99ca-c9ef2c44438e"],
Cell[149907, 2828, 233, 4, 33, "Output",ExpressionUUID->"7a8d172d-58d0-4249-bbd4-3cf70296c160"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[150189, 2838, 526, 8, 37, "Subsection",ExpressionUUID->"08b334a4-d5b8-7342-8386-1db35a3f4abd"],
Cell[CellGroupData[{
Cell[150740, 2850, 634, 13, 29, "Input",ExpressionUUID->"f291346a-7b0d-ed47-b2a3-5a8c664dffc7"],
Cell[151377, 2865, 13035, 402, 194, "Output",ExpressionUUID->"2491fce4-ce37-4a2a-858d-5de214985454"]
}, Open  ]],
Cell[164427, 3270, 228, 4, 33, "Text",ExpressionUUID->"5fad4a59-e13b-e945-829d-6b5214f3e7ef"],
Cell[CellGroupData[{
Cell[164680, 3278, 595, 14, 29, "Input",ExpressionUUID->"648bd8a4-6fed-5d4d-9291-6edf17bb4e5d"],
Cell[165278, 3294, 379, 7, 33, "Output",ExpressionUUID->"4c6bc559-4053-444d-a823-9f1869256453"]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[165718, 3308, 285, 4, 52, "Section",ExpressionUUID->"c59d6c3a-6d51-4444-9820-9f8160119815"],
Cell[CellGroupData[{
Cell[166028, 3316, 427, 7, 53, "Subsection",ExpressionUUID->"d11bcbe3-4466-8d48-8d95-b256984be2d3"],
Cell[CellGroupData[{
Cell[166480, 3327, 533, 11, 29, "Input",ExpressionUUID->"745a30b3-f1a0-bf42-9ffa-c1b54561d882"],
Cell[167016, 3340, 17303, 534, 217, "Output",ExpressionUUID->"b0a901e8-41a8-4b4a-9499-5932f34fc90b"]
}, Open  ]],
Cell[184334, 3877, 227, 4, 33, "Text",ExpressionUUID->"08c071f4-252b-aa43-be49-a0ca56e11356"],
Cell[CellGroupData[{
Cell[184586, 3885, 365, 9, 29, "Input",ExpressionUUID->"285c8516-1343-ef41-889d-377d6b76f101"],
Cell[184954, 3896, 253, 4, 33, "Output",ExpressionUUID->"abb9f1be-0168-44c0-99ff-0a99b51a35d0"]
}, Open  ]],
Cell[185222, 3903, 301, 7, 33, "Text",ExpressionUUID->"ac906af1-03bc-9b47-8793-0b27eca0927c"],
Cell[CellGroupData[{
Cell[185548, 3914, 346, 8, 29, "Input",ExpressionUUID->"6c09188a-3ff5-f747-97e8-6faef00bca5d"],
Cell[185897, 3924, 1678, 53, 56, "Output",ExpressionUUID->"b416e076-6399-4a9a-8d06-d4895d4c7777"]
}, Open  ]],
Cell[CellGroupData[{
Cell[187612, 3982, 348, 8, 29, "Input",ExpressionUUID->"1edc746d-af50-bc47-9b64-cd43312195a5"],
Cell[187963, 3992, 811, 25, 56, "Output",ExpressionUUID->"323df57b-5bd2-4d7f-ba82-af3eead735b6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[188811, 4022, 350, 8, 29, "Input",ExpressionUUID->"6d0d8535-6938-684e-9954-b7e60f27649c"],
Cell[189164, 4032, 1626, 52, 56, "Output",ExpressionUUID->"595a7418-abed-44a8-b987-a2bf825e650f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[190827, 4089, 346, 8, 29, "Input",ExpressionUUID->"f558bb35-a1e6-0f47-8d72-f926f2745b0c"],
Cell[191176, 4099, 813, 26, 56, "Output",ExpressionUUID->"a386d76e-d08a-4ff8-bff6-db8c3d5d49cd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[192026, 4130, 311, 8, 29, "Input",ExpressionUUID->"4c9cd8b0-b37a-ca49-80d8-70c8a25a82b0"],
Cell[192340, 4140, 233, 4, 33, "Output",ExpressionUUID->"18b26402-576a-4d0d-a96b-f911b1751bb0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[192610, 4149, 313, 8, 29, "Input",ExpressionUUID->"68354e3d-ad27-4345-8581-9d31da974d93"],
Cell[192926, 4159, 200, 4, 33, "Output",ExpressionUUID->"88713b4d-8932-4aa3-a7b8-2c8c94469e20"]
}, Open  ]],
Cell[CellGroupData[{
Cell[193163, 4168, 311, 8, 29, "Input",ExpressionUUID->"cc838989-cf85-5f47-9262-8098b3d80cb8"],
Cell[193477, 4178, 206, 4, 33, "Output",ExpressionUUID->"75ca588d-6aaf-4ba2-966c-b903743889c1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[193720, 4187, 313, 8, 29, "Input",ExpressionUUID->"9fae3d6a-98e9-1d47-bde8-4c8d723098ab"],
Cell[194036, 4197, 204, 4, 33, "Output",ExpressionUUID->"98d6a6d3-f33c-4e04-a9c5-eb67eb19a123"]
}, Open  ]],
Cell[CellGroupData[{
Cell[194277, 4206, 11025, 185, 44, "Input",ExpressionUUID->"a38a26e4-ec0a-c64e-b19b-7463a33c28c6"],
Cell[205305, 4393, 11011, 184, 48, "Output",ExpressionUUID->"4f89e226-3658-4532-b9a4-c439503f2796"]
}, Open  ]],
Cell[CellGroupData[{
Cell[216353, 4582, 320, 8, 29, "Input",ExpressionUUID->"d3d162b5-312d-cb49-a90c-346a609d0955"],
Cell[216676, 4592, 1398, 47, 35, "Output",ExpressionUUID->"9a6e806b-4885-4f0a-926c-41daad947a4b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[218111, 4644, 320, 8, 29, "Input",ExpressionUUID->"24c95e72-cc2e-d946-b728-2178fbc80ca0"],
Cell[218434, 4654, 1172, 40, 35, "Output",ExpressionUUID->"b6abcc76-02d0-435f-8af5-65c424a103f4"]
}, Open  ]],
Cell[CellGroupData[{
Cell[219643, 4699, 291, 6, 29, "Input",ExpressionUUID->"2eb77c89-7e79-a64a-af37-e43a5f79565e"],
Cell[219937, 4707, 205, 4, 33, "Output",ExpressionUUID->"6610ea31-c814-4cb8-9aa6-5ae72b8463ef"]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

